/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.net.core.CoreNIOServices;
import com.tc.net.core.SocketParams;
import com.tc.net.core.TCComm;
import com.tc.net.core.TCWorkerCommManager;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TCCommImpl
implements TCComm {
    private final TCWorkerCommManager workerCommMgr;
    private final CoreNIOServices commThread;
    private final String commThreadName;
    private static final Logger logger = LoggerFactory.getLogger(TCCommImpl.class);
    private volatile boolean started = false;

    TCCommImpl(String name, int workerCommCount, SocketParams socketParams) {
        if (workerCommCount > 0) {
            this.workerCommMgr = new TCWorkerCommManager(name, workerCommCount, socketParams);
        } else {
            logger.debug("Comm Worker Threads NOT requested");
            this.workerCommMgr = null;
        }
        this.commThreadName = name + ":TCComm Main Selector Thread";
        this.commThread = new CoreNIOServices(this.commThreadName, this.workerCommMgr, socketParams);
    }

    protected int getWeightForWorkerComm(int workerCommId) {
        if (this.workerCommMgr != null) {
            return this.workerCommMgr.getWeightForWorkerComm(workerCommId);
        }
        return 0;
    }

    protected CoreNIOServices getWorkerComm(int workerCommId) {
        if (this.workerCommMgr != null) {
            return this.workerCommMgr.getWorkerComm(workerCommId);
        }
        return null;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isStopped() {
        return !this.started;
    }

    @Override
    public final synchronized void start() {
        if (!this.started) {
            this.started = true;
            if (logger.isDebugEnabled()) {
                logger.debug("Start requested");
            }
            if (this.workerCommMgr != null) {
                this.workerCommMgr.start();
            }
            this.commThread.start();
        }
    }

    @Override
    public final synchronized void stop() {
        if (this.started) {
            this.started = false;
            if (logger.isDebugEnabled()) {
                logger.debug("Stop requested");
            }
            this.commThread.requestStop();
            if (this.workerCommMgr != null) {
                this.workerCommMgr.stop();
            }
        }
    }

    public CoreNIOServices nioServiceThreadForNewConnection() {
        return this.commThread;
    }

    public CoreNIOServices nioServiceThreadForNewListener() {
        return this.commThread;
    }

    public Map<String, ?> getState() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", this.commThreadName);
        map.put("threads", this.commThread.getState());
        if (this.workerCommMgr != null) {
            map.put("workers", this.workerCommMgr.getState());
        }
        return map;
    }

    @Override
    public void pause() {
        this.workerCommMgr.pause();
    }

    @Override
    public void unpause() {
        this.workerCommMgr.unpause();
    }
}

