/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.event.logger.handler;

import java.util.HashMap;
import org.flowable.common.engine.api.delegate.event.FlowableEntityEvent;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.event.FlowableEntityWithVariablesEvent;
import org.flowable.engine.impl.event.logger.handler.AbstractDatabaseEventLoggerEventHandler;
import org.flowable.engine.impl.persistence.entity.EventLogEntryEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;

public class ProcessInstanceStartedEventHandler
extends AbstractDatabaseEventLoggerEventHandler {
    private static final String TYPE = "PROCESSINSTANCE_START";

    @Override
    public EventLogEntryEntity generateEventLogEntry(CommandContext commandContext) {
        FlowableEntityWithVariablesEvent eventWithVariables;
        FlowableEntityEvent entityEvent = (FlowableEntityEvent)this.event;
        ExecutionEntity processInstanceEntity = (ExecutionEntity)entityEvent.getEntity();
        HashMap<String, Object> data = new HashMap<String, Object>();
        this.putInMapIfNotNull(data, "id", processInstanceEntity.getId());
        this.putInMapIfNotNull(data, "businessKey", processInstanceEntity.getBusinessKey());
        this.putInMapIfNotNull(data, "processDefinitionId", processInstanceEntity.getProcessDefinitionId());
        this.putInMapIfNotNull(data, "name", processInstanceEntity.getName());
        this.putInMapIfNotNull(data, "createTime", this.timeStamp);
        if (this.event instanceof FlowableEntityWithVariablesEvent && (eventWithVariables = (FlowableEntityWithVariablesEvent)this.event).getVariables() != null && !eventWithVariables.getVariables().isEmpty()) {
            HashMap<String, Object> variableMap = new HashMap<String, Object>();
            for (Object variableName : eventWithVariables.getVariables().keySet()) {
                this.putInMapIfNotNull(variableMap, (String)variableName, eventWithVariables.getVariables().get(variableName));
            }
            this.putInMapIfNotNull(data, "variables", variableMap);
        }
        return this.createEventLogEntry(TYPE, processInstanceEntity.getProcessDefinitionId(), processInstanceEntity.getId(), null, null, data);
    }
}

