/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.matrix.data.LibMatrixMult;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class LinearAlgebraUtils {
    protected static final Log LOG = LogFactory.getLog((String)LinearAlgebraUtils.class.getName());

    public static double dotProduct(double[] a, double[] b, int len) {
        return LibMatrixMult.dotProduct(a, b, 0, 0, len);
    }

    public static double dotProduct(double[] a, double[] b, int ai, int bi, int len) {
        return LibMatrixMult.dotProduct(a, b, ai, bi, len);
    }

    public static void vectMultiplyAdd(double aval, double[] b, double[] c, int bi, int ci, int len) {
        LibMatrixMult.vectMultiplyAdd(aval, b, c, bi, ci, len);
    }

    public static void vectMultiplyAdd(double aval, double[] b, double[] c, int[] bix, int bi, int ci, int len) {
        LibMatrixMult.vectMultiplyAdd(aval, b, c, bix, bi, ci, len);
    }

    public static void vectAdd(double[] a, double[] c, int ai, int ci, int len) {
        LibMatrixMult.vectAdd(a, c, ai, ci, len);
    }

    public static void vectAdd(double aval, double[] c, char[] bix, int bi, int ci, int len) {
        int j;
        int bn = len % 8;
        for (j = bi; j < bi + bn; ++j) {
            int n = ci + bix[j];
            c[n] = c[n] + aval;
        }
        for (j = bi + bn; j < bi + len; j += 8) {
            int n = ci + bix[j + 0];
            c[n] = c[n] + aval;
            int n2 = ci + bix[j + 1];
            c[n2] = c[n2] + aval;
            int n3 = ci + bix[j + 2];
            c[n3] = c[n3] + aval;
            int n4 = ci + bix[j + 3];
            c[n4] = c[n4] + aval;
            int n5 = ci + bix[j + 4];
            c[n5] = c[n5] + aval;
            int n6 = ci + bix[j + 5];
            c[n6] = c[n6] + aval;
            int n7 = ci + bix[j + 6];
            c[n7] = c[n7] + aval;
            int n8 = ci + bix[j + 7];
            c[n8] = c[n8] + aval;
        }
    }

    public static void vectListAdd(double[] values, double[] c, char[] bix, int rl, int ru, int off) {
        int j;
        int bn = (ru - rl) % 8;
        for (j = rl; j < rl + bn; ++j) {
            int n = j + off;
            c[n] = c[n] + values[bix[j]];
        }
        for (j = rl + bn; j < ru; j += 8) {
            int n = j + 0 + off;
            c[n] = c[n] + values[bix[j + 0]];
            int n2 = j + 1 + off;
            c[n2] = c[n2] + values[bix[j + 1]];
            int n3 = j + 2 + off;
            c[n3] = c[n3] + values[bix[j + 2]];
            int n4 = j + 3 + off;
            c[n4] = c[n4] + values[bix[j + 3]];
            int n5 = j + 4 + off;
            c[n5] = c[n5] + values[bix[j + 4]];
            int n6 = j + 5 + off;
            c[n6] = c[n6] + values[bix[j + 5]];
            int n7 = j + 6 + off;
            c[n7] = c[n7] + values[bix[j + 6]];
            int n8 = j + 7 + off;
            c[n8] = c[n8] + values[bix[j + 7]];
        }
    }

    public static void vectListAdd(double[] values, double[] c, char[] bix, int rl, int ru) {
        int j;
        int bn = (ru - rl) % 8;
        for (j = rl; j < rl + bn; ++j) {
            int n = j;
            c[n] = c[n] + values[bix[j]];
        }
        for (j = rl + bn; j < ru; j += 8) {
            int n = j + 0;
            c[n] = c[n] + values[bix[j + 0]];
            int n2 = j + 1;
            c[n2] = c[n2] + values[bix[j + 1]];
            int n3 = j + 2;
            c[n3] = c[n3] + values[bix[j + 2]];
            int n4 = j + 3;
            c[n4] = c[n4] + values[bix[j + 3]];
            int n5 = j + 4;
            c[n5] = c[n5] + values[bix[j + 4]];
            int n6 = j + 5;
            c[n6] = c[n6] + values[bix[j + 5]];
            int n7 = j + 6;
            c[n7] = c[n7] + values[bix[j + 6]];
            int n8 = j + 7;
            c[n8] = c[n8] + values[bix[j + 7]];
        }
    }

    public static void vectListAdd(double[] values, double[] c, byte[] bix, int rl, int ru, int off) {
        int j;
        int bn = (ru - rl) % 8;
        for (j = rl; j < rl + bn; ++j) {
            int n = j + off;
            c[n] = c[n] + values[bix[j] & 0xFF];
        }
        for (j = rl + bn; j < ru; j += 8) {
            int n = j + 0 + off;
            c[n] = c[n] + values[bix[j + 0] & 0xFF];
            int n2 = j + 1 + off;
            c[n2] = c[n2] + values[bix[j + 1] & 0xFF];
            int n3 = j + 2 + off;
            c[n3] = c[n3] + values[bix[j + 2] & 0xFF];
            int n4 = j + 3 + off;
            c[n4] = c[n4] + values[bix[j + 3] & 0xFF];
            int n5 = j + 4 + off;
            c[n5] = c[n5] + values[bix[j + 4] & 0xFF];
            int n6 = j + 5 + off;
            c[n6] = c[n6] + values[bix[j + 5] & 0xFF];
            int n7 = j + 6 + off;
            c[n7] = c[n7] + values[bix[j + 6] & 0xFF];
            int n8 = j + 7 + off;
            c[n8] = c[n8] + values[bix[j + 7] & 0xFF];
        }
    }

    public static void vectListAdd(double[] values, double[] c, int rl, int ru, int cl, int cu, int cut, int valOff) {
        int j = rl;
        int off = rl * cut;
        while (j < ru) {
            int k = cl;
            int h = valOff;
            while (k < cu) {
                int n = off + k;
                c[n] = c[n] + values[h];
                ++k;
                ++h;
            }
            ++j;
            off += cut;
        }
    }

    public static void vectListAdd(double[] preAggregatedValues, double[] c, int rl, int ru, int[] outputColumns, int cut, int n) {
        n *= outputColumns.length;
        int j = rl;
        int off = rl * cut;
        while (j < ru) {
            for (int k = 0; k < outputColumns.length; ++k) {
                int n2 = off + outputColumns[k];
                c[n2] = c[n2] + preAggregatedValues[n + k];
            }
            ++j;
            off += cut;
        }
    }

    public static void vectListAdd(double[] values, double[] c, byte[] bix, int rl, int ru) {
        int j;
        int bn = (ru - rl) % 8;
        for (j = rl; j < rl + bn; ++j) {
            int n = j;
            c[n] = c[n] + values[bix[j] & 0xFF];
        }
        for (j = rl + bn; j < ru; j += 8) {
            int n = j + 0;
            c[n] = c[n] + values[bix[j + 0] & 0xFF];
            int n2 = j + 1;
            c[n2] = c[n2] + values[bix[j + 1] & 0xFF];
            int n3 = j + 2;
            c[n3] = c[n3] + values[bix[j + 2] & 0xFF];
            int n4 = j + 3;
            c[n4] = c[n4] + values[bix[j + 3] & 0xFF];
            int n5 = j + 4;
            c[n5] = c[n5] + values[bix[j + 4] & 0xFF];
            int n6 = j + 5;
            c[n6] = c[n6] + values[bix[j + 5] & 0xFF];
            int n7 = j + 6;
            c[n7] = c[n7] + values[bix[j + 6] & 0xFF];
            int n8 = j + 7;
            c[n8] = c[n8] + values[bix[j + 7] & 0xFF];
        }
    }

    public static void vectAdd(double aval, double[] c, int ci, int len) {
        int j;
        int bn = len % 8;
        for (j = 0; j < bn; ++j) {
            int n = ci + j;
            c[n] = c[n] + aval;
        }
        for (j = bn; j < len; j += 8) {
            int n = ci + j + 0;
            c[n] = c[n] + aval;
            int n2 = ci + j + 1;
            c[n2] = c[n2] + aval;
            int n3 = ci + j + 2;
            c[n3] = c[n3] + aval;
            int n4 = ci + j + 3;
            c[n4] = c[n4] + aval;
            int n5 = ci + j + 4;
            c[n5] = c[n5] + aval;
            int n6 = ci + j + 5;
            c[n6] = c[n6] + aval;
            int n7 = ci + j + 6;
            c[n7] = c[n7] + aval;
            int n8 = ci + j + 7;
            c[n8] = c[n8] + aval;
        }
    }

    public static double vectSum(double[] a, char[] bix, int ai, int bi, int len) {
        int j;
        double val = 0.0;
        int bn = len % 8;
        for (j = bi; j < bi + bn; ++j) {
            val += a[ai + bix[j]];
        }
        for (j = bi + bn; j < bi + len; j += 8) {
            val += a[ai + bix[j + 0]] + a[ai + bix[j + 1]] + a[ai + bix[j + 2]] + a[ai + bix[j + 3]] + a[ai + bix[j + 4]] + a[ai + bix[j + 5]] + a[ai + bix[j + 6]] + a[ai + bix[j + 7]];
        }
        return val;
    }

    public static double vectSum(double[] a, int ai, int len) {
        int j;
        double val = 0.0;
        int bn = len % 8;
        for (j = ai; j < ai + bn; ++j) {
            val += a[j];
        }
        for (j = ai + bn; j < ai + len; j += 8) {
            val += a[j + 0] + a[j + 1] + a[j + 2] + a[j + 3] + a[j + 4] + a[j + 5] + a[j + 6] + a[j + 7];
        }
        return val;
    }

    public static long copyUpperToLowerTriangle(MatrixBlock ret) {
        return LibMatrixMult.copyUpperToLowerTriangle(ret);
    }

    public static void copyNonZerosToUpperTriangle(MatrixBlock ret, MatrixBlock tmp, int ix) {
        double[] a = tmp.getDenseBlockValues();
        DenseBlock c = ret.getDenseBlock();
        for (int i = 0; i < tmp.getNumColumns(); ++i) {
            if (a[i] == 0.0) continue;
            int row = ix < i ? ix : i;
            int col = ix < i ? i : ix;
            c.set(row, col, a[i]);
        }
    }

    public static int getClosestK(int[] a, int x) {
        int low = 0;
        int high = a.length - 1;
        while (low < high) {
            int mid = (low + high) / 2;
            int d1 = Math.abs(a[mid] - x);
            int d2 = Math.abs(a[mid + 1] - x);
            if (d2 <= d1) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        return high;
    }
}

