/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor;

import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalTaskQueue<T> {
    public static final int MAX_SIZE = 100000;
    public static final Object NO_MORE_TASKS = null;
    private LinkedList<T> _data = new LinkedList();
    private boolean _closedInput = false;
    private static final Log LOG = LogFactory.getLog((String)LocalTaskQueue.class.getName());

    public synchronized void enqueueTask(T t) throws InterruptedException {
        while (this._data.size() + 1 > 100000) {
            LOG.warn((Object)"MAX_SIZE of task queue reached.");
            this.wait();
        }
        this._data.addLast(t);
        this.notify();
    }

    public synchronized T dequeueTask() throws InterruptedException {
        while (this._data.isEmpty()) {
            if (!this._closedInput) {
                this.wait();
                continue;
            }
            return (T)NO_MORE_TASKS;
        }
        T t = this._data.removeFirst();
        this.notify();
        return t;
    }

    public synchronized void closeInput() {
        this._closedInput = true;
        this.notifyAll();
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TASK QUEUE (size=");
        sb.append(this._data.size());
        sb.append(",close=");
        sb.append(this._closedInput);
        sb.append(")\n");
        int count = 1;
        for (Object t : this._data) {
            sb.append("  TASK #");
            sb.append(count);
            sb.append(": ");
            sb.append(t.toString());
            sb.append("\n");
            ++count;
        }
        return sb.toString();
    }
}

