/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.app;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;

class EvalFilePaths {
    private final Path relativeSourceFilePath;
    private final Path extractFile;
    private long sourceFileLength = -1L;
    private long extractFileLength = -1L;

    public EvalFilePaths(Path relativeSourceFilePath, Path extractFile, long srcFileLen) {
        this(relativeSourceFilePath, extractFile);
        this.sourceFileLength = srcFileLen;
    }

    public EvalFilePaths(Path relativeSourceFilePath, Path extractFile) {
        if (extractFile != null && Files.isRegularFile(extractFile, new LinkOption[0])) {
            try {
                this.extractFileLength = Files.size(extractFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.relativeSourceFilePath = relativeSourceFilePath;
        this.extractFile = extractFile;
    }

    public Path getRelativeSourceFilePath() {
        return this.relativeSourceFilePath;
    }

    public Path getExtractFile() {
        return this.extractFile;
    }

    public long getSourceFileLength() {
        return this.sourceFileLength;
    }

    public long getExtractFileLength() {
        return this.extractFileLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvalFilePaths that = (EvalFilePaths)o;
        if (this.sourceFileLength != that.sourceFileLength) {
            return false;
        }
        if (this.extractFileLength != that.extractFileLength) {
            return false;
        }
        if (!Objects.equals(this.relativeSourceFilePath, that.relativeSourceFilePath)) {
            return false;
        }
        return Objects.equals(this.extractFile, that.extractFile);
    }

    public int hashCode() {
        int result = this.relativeSourceFilePath != null ? this.relativeSourceFilePath.hashCode() : 0;
        result = 31 * result + (this.extractFile != null ? this.extractFile.hashCode() : 0);
        result = 31 * result + (int)(this.sourceFileLength ^ this.sourceFileLength >>> 32);
        result = 31 * result + (int)(this.extractFileLength ^ this.extractFileLength >>> 32);
        return result;
    }

    public String toString() {
        return "EvalFilePaths{relativeSourceFilePath=" + String.valueOf(this.relativeSourceFilePath) + ", extractFile=" + String.valueOf(this.extractFile) + ", sourceFileLength=" + this.sourceFileLength + ", extractFileLength=" + this.extractFileLength + "}";
    }
}

