/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ImagingOpException;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform2D;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.util.j2d.AffineTransform2D;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

final class ResamplingGrid
extends AbstractMathTransform2D {
    private static final int MIN_TILE_SIZE = 4;
    static final double TOLERANCE = 0.125;
    private static final Cache<Key, MathTransform2D> CACHE = new Cache<Key, MathTransform2D>(12, 32768L, false){

        @Override
        protected int cost(MathTransform2D value) {
            if (value instanceof ResamplingGrid) {
                return ((ResamplingGrid)value).coordinates.length;
            }
            return 50;
        }
    };
    final int numXTiles;
    final int numYTiles;
    private final double tileWidth;
    private final double tileHeight;
    private final double xmin;
    private final double ymin;
    private final double[] coordinates;

    ResamplingGrid(MathTransform2D toSourceCenter, Rectangle bounds, Dimension depth) throws TransformException {
        this.xmin = bounds.x;
        this.ymin = bounds.y;
        this.tileWidth = Math.scalb(bounds.width, -depth.width);
        this.tileHeight = Math.scalb(bounds.height, -depth.height);
        this.numXTiles = 1 << depth.width;
        this.numYTiles = 1 << depth.height;
        this.coordinates = new double[(this.numXTiles + 1) * (this.numYTiles + 1) * 2];
        int p = 0;
        for (int y = 0; y <= this.numYTiles; ++y) {
            for (int x = 0; x <= this.numXTiles; ++x) {
                this.coordinates[p++] = x;
                this.coordinates[p++] = y;
            }
        }
        toSourceCenter = MathTransforms.concatenate(new AffineTransform2D(this.tileWidth, 0.0, 0.0, this.tileHeight, this.xmin, this.ymin), toSourceCenter);
        toSourceCenter.transform(this.coordinates, 0, this.coordinates, 0, p / 2);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        if (derivate) {
            throw new TransformException(Errors.format((short)162, "derivative"));
        }
        this.transform(srcPts, srcOff, dstPts, dstOff, 1);
        return null;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        if (srcOff < dstOff && srcPts == dstPts && numPts > 1) {
            super.transform(srcPts, srcOff, dstPts, dstOff, numPts);
            return;
        }
        int lineStride = this.numXTiles + 1;
        while (--numPts >= 0) {
            double x = (srcPts[srcOff++] - this.xmin) / this.tileWidth;
            double y = (srcPts[srcOff++] - this.ymin) / this.tileHeight;
            double txf = Math.floor(x);
            x -= txf;
            double tyf = Math.floor(y);
            y -= tyf;
            int tx = (int)txf;
            int ty = (int)tyf;
            if (tx < 0 || tx >= this.numXTiles || ty < 0 || ty >= this.numYTiles) {
                throw new TransformException(Errors.format((short)119));
            }
            int p00 = (tx + ty * lineStride) * 2;
            int p01 = p00 + 2;
            int p10 = p00 + 2 * lineStride;
            int p11 = p10 + 2;
            double mx = 1.0 - x;
            double my = 1.0 - y;
            dstPts[dstOff++] = my * (mx * this.coordinates[p00] + x * this.coordinates[p01]) + y * (mx * this.coordinates[p10] + x * this.coordinates[p11]);
            dstPts[dstOff++] = my * (mx * this.coordinates[p00 | 1] + x * this.coordinates[p01 | 1]) + y * (mx * this.coordinates[p10 | 1] + x * this.coordinates[p11 | 1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MathTransform2D getOrCreate(MathTransform2D toSourceCenter, Rectangle bounds) throws TransformException {
        Key key = new Key(toSourceCenter, bounds);
        MathTransform2D grid = CACHE.peek(key);
        if (grid == null) {
            Cache.Handler<MathTransform2D> handler = CACHE.lock(key);
            try {
                grid = handler.peek();
                if (grid == null) {
                    grid = ResamplingGrid.create(toSourceCenter, bounds);
                }
            }
            finally {
                handler.putAndUnlock(grid);
            }
        }
        return grid;
    }

    static MathTransform2D create(MathTransform2D toSourceCenter, Rectangle bounds) throws TransformException {
        Dimension depth;
        block3: {
            MathTransform2D toSourceCorner = (MathTransform2D)MathTransforms.concatenate(MathTransforms.translation(-0.5, -0.5), (MathTransform)toSourceCenter, MathTransforms.translation(0.5, 0.5));
            double xmin = bounds.getMinX();
            double xmax = bounds.getMaxX();
            double ymin = bounds.getMinY();
            double ymax = bounds.getMaxY();
            Point2D.Double point = new Point2D.Double();
            point.x = xmin;
            point.y = ymax;
            Matrix2 upperLeft = ResamplingGrid.derivative(toSourceCorner, point);
            point.x = xmax;
            point.y = ymax;
            Matrix2 upperRight = ResamplingGrid.derivative(toSourceCorner, point);
            point.x = xmin;
            point.y = ymin;
            Matrix2 lowerLeft = ResamplingGrid.derivative(toSourceCorner, point);
            point.x = xmax;
            point.y = ymin;
            Matrix2 lowerRight = ResamplingGrid.derivative(toSourceCorner, point);
            depth = ResamplingGrid.depth(toSourceCorner, point, new Point2D.Double(0.25 / (xmax - xmin), 0.25 / (ymax - ymin)), xmin, xmax, ymin, ymax, upperLeft, upperRight, lowerLeft, lowerRight);
            if (depth.width == 0 && depth.height == 0) {
                double xcnt = bounds.getCenterX();
                double ycnt = bounds.getCenterY();
                point.x = xmax;
                point.y = ycnt;
                Point2D p = toSourceCenter.transform(point, point);
                double m00 = p.getX();
                double m10 = p.getY();
                point.x = xmin;
                point.y = ycnt;
                p = toSourceCenter.transform(point, point);
                m00 -= p.getX();
                m10 -= p.getY();
                point.x = xcnt;
                point.y = ymax;
                p = toSourceCenter.transform(point, point);
                double m01 = p.getX();
                double m11 = p.getY();
                point.x = xcnt;
                point.y = ymin;
                p = toSourceCenter.transform(point, point);
                m01 -= p.getX();
                m11 -= p.getY();
                point.x = xcnt;
                point.y = ycnt;
                p = toSourceCenter.transform(point, point);
                double width = bounds.getWidth();
                double height = bounds.getHeight();
                AffineTransform tr = new AffineTransform(m00 / width, m10 / width, m01 / height, m11 / height, p.getX(), p.getY());
                tr.translate(-xcnt, -ycnt);
                p = null;
                for (int i = 0; i < 4; ++i) {
                    point.x = (i & 1) == 0 ? xmin : xmax;
                    point.y = (i & 2) == 0 ? ymin : ymax;
                    p = tr.transform(point, p);
                    Point2D expected = toSourceCenter.transform(point, point);
                    if (Math.abs(p.getX() - expected.getX()) <= 0.125 && Math.abs(p.getY() - expected.getY()) <= 0.125) {
                        continue;
                    }
                    break block3;
                }
                return new AffineTransform2D(tr);
            }
        }
        return new ResamplingGrid(toSourceCenter, bounds, depth);
    }

    private static Dimension depth(MathTransform2D toSourceCorner, Point2D.Double point, Point2D.Double tolerance, double xmin, double xmax, double ymin, double ymax, Matrix2 upperLeft, Matrix2 upperRight, Matrix2 lowerLeft, Matrix2 lowerRight) throws TransformException {
        Dimension depth;
        if (!(xmax - xmin >= 4.0) || !(ymax - ymin >= 4.0)) {
            throw new ImagingOpException(null);
        }
        double oldTolX = tolerance.x;
        double oldTolY = tolerance.y;
        tolerance.x *= 2.0;
        tolerance.y *= 2.0;
        double centerX = point.x = 0.5 * (xmin + xmax);
        double centerY = point.y = 0.5 * (ymin + ymax);
        Matrix2 center = Matrix2.castOrCopy(toSourceCorner.derivative(point));
        point.x = xmin;
        point.y = centerY;
        Matrix2 centerLeft = ResamplingGrid.derivative(toSourceCorner, point);
        point.x = xmax;
        point.y = centerY;
        Matrix2 centerRight = ResamplingGrid.derivative(toSourceCorner, point);
        point.x = centerX;
        point.y = ymin;
        Matrix2 centerLower = ResamplingGrid.derivative(toSourceCorner, point);
        point.x = centerX;
        point.y = ymax;
        Matrix2 centerUpper = ResamplingGrid.derivative(toSourceCorner, point);
        boolean cl = ResamplingGrid.equals(center, centerLeft, tolerance);
        boolean cr = ResamplingGrid.equals(center, centerRight, tolerance);
        boolean cb = ResamplingGrid.equals(center, centerLower, tolerance);
        boolean cu = ResamplingGrid.equals(center, centerUpper, tolerance);
        int nx = 0;
        int ny = 0;
        if (!(cl & cu) || !ResamplingGrid.equals(center, upperLeft, tolerance)) {
            depth = ResamplingGrid.depth(toSourceCorner, point, tolerance, xmin, centerX, centerY, ymax, upperLeft, centerUpper, centerLeft, center);
            ResamplingGrid.incrementNonAffineDimension(cl, cu, depth);
            nx = depth.width;
            ny = depth.height;
        }
        if (!(cr & cu) || !ResamplingGrid.equals(center, upperRight, tolerance)) {
            depth = ResamplingGrid.depth(toSourceCorner, point, tolerance, centerX, xmax, centerY, ymax, centerUpper, upperRight, center, centerRight);
            ResamplingGrid.incrementNonAffineDimension(cr, cu, depth);
            nx = Math.max(nx, depth.width);
            ny = Math.max(ny, depth.height);
        }
        if (!(cl & cb) || !ResamplingGrid.equals(center, lowerLeft, tolerance)) {
            depth = ResamplingGrid.depth(toSourceCorner, point, tolerance, xmin, centerX, ymin, centerY, centerLeft, center, lowerLeft, centerLower);
            ResamplingGrid.incrementNonAffineDimension(cl, cb, depth);
            nx = Math.max(nx, depth.width);
            ny = Math.max(ny, depth.height);
        }
        if (!(cr & cb) || !ResamplingGrid.equals(center, lowerRight, tolerance)) {
            depth = ResamplingGrid.depth(toSourceCorner, point, tolerance, centerX, xmax, ymin, centerY, center, centerRight, centerLower, lowerRight);
            ResamplingGrid.incrementNonAffineDimension(cr, cb, depth);
            nx = Math.max(nx, depth.width);
            ny = Math.max(ny, depth.height);
        }
        tolerance.x = oldTolX;
        tolerance.y = oldTolY;
        return new Dimension(nx, ny);
    }

    private static void incrementNonAffineDimension(boolean he, boolean ve, Dimension depth) {
        if (he == ve) {
            ++depth.width;
            ++depth.height;
        } else if (ve) {
            ++depth.width;
        } else {
            ++depth.height;
        }
    }

    private static Matrix2 derivative(MathTransform2D toSourceCenter, Point2D point) throws TransformException {
        return Matrix2.castOrCopy(toSourceCenter.derivative(point));
    }

    private static boolean equals(Matrix2 center, Matrix2 corner, Point2D.Double tolerance) {
        return Math.abs(center.m00 - corner.m00) + Math.abs(center.m01 - corner.m01) <= tolerance.x && Math.abs(center.m10 - corner.m10) + Math.abs(center.m11 - corner.m11) <= tolerance.y;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        formatter.append(this.numXTiles);
        formatter.append(this.numYTiles);
        formatter.setInvalidWKT(ResamplingGrid.class, null);
        return "ResamplingGrid";
    }

    private static final class Key {
        private final MathTransform2D toSourceCenter;
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        Key(MathTransform2D toSourceCenter, Rectangle bounds) {
            this.toSourceCenter = toSourceCenter;
            this.x = bounds.x;
            this.y = bounds.y;
            this.width = bounds.width;
            this.height = bounds.height;
        }

        public int hashCode() {
            return (this.x * 31 + this.y * 31 + this.width) * 31 + this.height + this.toSourceCenter.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return this.x == other.x && this.y == other.y && this.width == other.width && this.height == other.height && this.toSourceCenter.equals(other.toSourceCenter);
            }
            return false;
        }
    }
}

