/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.io.stream.HttpByteChannel;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ForwardOnlyStorageException;
import org.apache.sis.storage.base.StoreUtilities;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public abstract class ChannelFactory {
    private static final Set<StandardOpenOption> ILLEGAL_OPTIONS = EnumSet.of(StandardOpenOption.APPEND, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.DELETE_ON_CLOSE);
    public final boolean suggestDirectBuffer;

    protected ChannelFactory(boolean suggestDirectBuffer) {
        this.suggestDirectBuffer = suggestDirectBuffer;
    }

    public static ChannelFactory prepare(Object storage, boolean allowWriteOnly, String encoding, OpenOption[] options) throws IOException {
        Path path;
        Serializable file;
        Set<StandardOpenOption> optionSet;
        block24: {
            if (options == null || options.length == 0) {
                optionSet = Set.of(StandardOpenOption.READ);
            } else {
                optionSet = new HashSet<OpenOption>(Arrays.asList(options));
                optionSet.add(StandardOpenOption.READ);
                if (!allowWriteOnly && optionSet.removeAll(ILLEGAL_OPTIONS)) {
                    throw new IllegalArgumentException(Errors.format((short)45, "options", Arrays.toString(options)));
                }
            }
            if (storage instanceof ReadableByteChannel || allowWriteOnly && storage instanceof WritableByteChannel) {
                return new Stream(storage, storage instanceof FileChannel);
            }
            if (storage instanceof InputStream) {
                return new Stream(storage, storage.getClass() == FileInputStream.class);
            }
            if (allowWriteOnly && storage instanceof OutputStream) {
                return new Stream(storage, storage.getClass() == FileOutputStream.class);
            }
            if (storage instanceof URL) {
                try {
                    storage = IOUtilities.toPath((URL)storage, encoding);
                }
                catch (IOException e) {
                    ChannelFactory.recoverableException(e);
                }
            } else if (storage instanceof URI) {
                final URI uri = (URI)storage;
                if (!uri.isAbsolute()) {
                    throw new IOException(Resources.format((short)11, uri));
                }
                if (IOUtilities.isHTTP(uri.getScheme())) {
                    return new ChannelFactory(true){

                        @Override
                        public ReadableByteChannel readable(String filename, StoreListeners listeners) throws IOException {
                            return new HttpByteChannel(filename, uri);
                        }

                        @Override
                        public WritableByteChannel writable(String filename, StoreListeners listeners) throws IOException {
                            return Channels.newChannel(uri.toURL().openConnection().getOutputStream());
                        }
                    };
                }
                try {
                    storage = Path.of(uri);
                }
                catch (IllegalArgumentException | FileSystemNotFoundException e) {
                    try {
                        storage = uri.toURL();
                    }
                    catch (MalformedURLException ioe) {
                        e.addSuppressed(ioe);
                        throw e;
                    }
                    ChannelFactory.recoverableException(e);
                }
            } else {
                if (storage instanceof CharSequence) {
                    storage = IOUtilities.toFileOrURL(storage.toString(), encoding);
                }
                if (storage instanceof File) {
                    file = (File)storage;
                    try {
                        storage = ((File)file).toPath();
                    }
                    catch (InvalidPathException e) {
                        if (!((File)file).isFile()) break block24;
                        return new Fallback((File)file, e);
                    }
                }
            }
        }
        if (storage instanceof URL) {
            file = (URL)storage;
            return new ChannelFactory(false, (URL)file){
                final /* synthetic */ URL val$file;
                {
                    this.val$file = uRL;
                    super(suggestDirectBuffer);
                }

                @Override
                public InputStream inputStream(String filename, StoreListeners listeners) throws IOException {
                    return this.val$file.openStream();
                }

                @Override
                public OutputStream outputStream(String filename, StoreListeners listeners) throws IOException {
                    return this.val$file.openConnection().getOutputStream();
                }

                @Override
                public ReadableByteChannel readable(String filename, StoreListeners listeners) throws IOException {
                    return Channels.newChannel(this.val$file.openStream());
                }

                @Override
                public WritableByteChannel writable(String filename, StoreListeners listeners) throws IOException {
                    return Channels.newChannel(this.val$file.openConnection().getOutputStream());
                }
            };
        }
        if (storage instanceof Path && !Files.isDirectory(path = (Path)storage, new LinkOption[0])) {
            return new ChannelFactory(true){

                @Override
                public ReadableByteChannel readable(String filename, StoreListeners listeners) throws IOException {
                    return Files.newByteChannel(path, optionSet, new FileAttribute[0]);
                }

                @Override
                public WritableByteChannel writable(String filename, StoreListeners listeners) throws IOException {
                    return Files.newByteChannel(path, optionSet, new FileAttribute[0]);
                }

                @Override
                public boolean isCreateNew() {
                    if (optionSet.contains(StandardOpenOption.CREATE_NEW)) {
                        return true;
                    }
                    if (optionSet.contains(StandardOpenOption.CREATE)) {
                        return Files.notExists(path, new LinkOption[0]);
                    }
                    return false;
                }
            };
        }
        return null;
    }

    public boolean isCoupled() {
        return false;
    }

    public boolean canReopen() {
        return true;
    }

    public boolean isCreateNew() {
        return false;
    }

    public InputStream inputStream(String filename, StoreListeners listeners) throws DataStoreException, IOException {
        return Channels.newInputStream(this.readable(filename, listeners));
    }

    public OutputStream outputStream(String filename, StoreListeners listeners) throws DataStoreException, IOException {
        return Channels.newOutputStream(this.writable(filename, listeners));
    }

    public abstract ReadableByteChannel readable(String var1, StoreListeners var2) throws DataStoreException, IOException;

    public abstract WritableByteChannel writable(String var1, StoreListeners var2) throws DataStoreException, IOException;

    private static void recoverableException(Exception warning) {
        Logging.recoverableException(StoreUtilities.LOGGER, ChannelFactory.class, "prepare", warning);
    }

    private static final class Stream
    extends ChannelFactory {
        private Object storage;

        Stream(Object storage, boolean suggestDirectBuffer) {
            super(suggestDirectBuffer);
            this.storage = storage;
        }

        @Override
        public boolean isCoupled() {
            return true;
        }

        @Override
        public boolean canReopen() {
            return this.storage != null;
        }

        @Override
        public InputStream inputStream(String filename, StoreListeners listeners) throws DataStoreException, IOException {
            Object in = this.storage;
            if (in instanceof InputStream) {
                this.storage = null;
                return (InputStream)in;
            }
            return super.inputStream(filename, listeners);
        }

        @Override
        public OutputStream outputStream(String filename, StoreListeners listeners) throws DataStoreException, IOException {
            Object out = this.storage;
            if (out instanceof OutputStream) {
                this.storage = null;
                return (OutputStream)out;
            }
            return super.outputStream(filename, listeners);
        }

        @Override
        public ReadableByteChannel readable(String filename, StoreListeners listeners) throws DataStoreException, IOException {
            Object in = this.storage;
            if (in instanceof ReadableByteChannel) {
                this.storage = null;
                return (ReadableByteChannel)in;
            }
            if (in instanceof InputStream) {
                this.storage = null;
                return Channels.newChannel((InputStream)in);
            }
            String message = Resources.format(in != null ? (short)25 : 18, filename);
            if (in != null) {
                throw new IOException(message);
            }
            throw new ForwardOnlyStorageException(message);
        }

        @Override
        public WritableByteChannel writable(String filename, StoreListeners listeners) throws DataStoreException, IOException {
            Object out = this.storage;
            if (out instanceof WritableByteChannel) {
                this.storage = null;
                return (WritableByteChannel)out;
            }
            if (out instanceof OutputStream) {
                this.storage = null;
                return Channels.newChannel((OutputStream)out);
            }
            String message = Resources.format(out != null ? (short)26 : 21, filename);
            if (out != null) {
                throw new IOException(message);
            }
            throw new ForwardOnlyStorageException(message);
        }
    }

    private static final class Fallback
    extends ChannelFactory {
        private final File file;
        private InvalidPathException cause;

        Fallback(File file, InvalidPathException cause) {
            super(true);
            this.file = file;
            this.cause = cause;
        }

        @Override
        public FileInputStream inputStream(String filename, StoreListeners listeners) throws IOException {
            FileInputStream in;
            try {
                in = new FileInputStream(this.file);
            }
            catch (IOException ioe) {
                if (this.cause != null) {
                    ioe.addSuppressed(this.cause);
                    this.cause = null;
                }
                throw ioe;
            }
            this.warning("inputStream", listeners);
            return in;
        }

        @Override
        public FileOutputStream outputStream(String filename, StoreListeners listeners) throws IOException {
            FileOutputStream out;
            try {
                out = new FileOutputStream(this.file);
            }
            catch (IOException ioe) {
                if (this.cause != null) {
                    ioe.addSuppressed(this.cause);
                    this.cause = null;
                }
                throw ioe;
            }
            this.warning("outputStream", listeners);
            return out;
        }

        private void warning(String method, StoreListeners listeners) {
            if (this.cause != null) {
                LogRecord record = new LogRecord(Level.WARNING, this.cause.toString());
                record.setLoggerName("org.apache.sis.storage");
                record.setSourceMethodName(method);
                record.setSourceClassName(ChannelFactory.class.getName());
                record.setThrown(this.cause);
                this.cause = null;
                if (listeners != null) {
                    listeners.warning(record);
                } else {
                    StoreUtilities.LOGGER.log(record);
                }
            }
        }

        @Override
        public ReadableByteChannel readable(String filename, StoreListeners listeners) throws IOException {
            return this.inputStream(filename, listeners).getChannel();
        }

        @Override
        public WritableByteChannel writable(String filename, StoreListeners listeners) throws IOException {
            return this.outputStream(filename, listeners).getChannel();
        }
    }
}

