/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Locale;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.RangeFormat;
import org.apache.sis.measure.ValueRange;
import org.opengis.util.InternationalString;

final class DomainRange<E extends Number>
extends NumberRange<E>
implements InternationalString {
    private static final long serialVersionUID = 702771264296112914L;
    private volatile transient String text;

    DomainRange(Class<E> type, ValueRange range) throws IllegalArgumentException {
        super(type, range);
    }

    @Override
    public String toString(Locale locale) {
        if (locale == null || locale == Locale.ROOT) {
            return this.toString();
        }
        RangeFormat format = new RangeFormat(locale, this.getElementType());
        return format.format(this);
    }

    @Override
    public String toString() {
        String s = this.text;
        if (s == null) {
            this.text = s = super.toString();
        }
        return s;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public int compareTo(InternationalString o) {
        if (o instanceof DomainRange) {
            return this.compareTo((DomainRange)o);
        }
        return this.toString().compareTo(o.toString());
    }

    @Override
    private int compareTo(DomainRange<?> range) {
        int c = Double.compare(this.getMinDouble(), range.getMinDouble());
        if (c == 0) {
            boolean b = this.isMinIncluded();
            if (b != range.isMinIncluded()) {
                c = b ? -1 : 1;
            } else {
                c = Double.compare(this.getMaxDouble(), range.getMaxDouble());
                if (c == 0 && (b = this.isMaxIncluded()) != range.isMaxIncluded()) {
                    c = b ? 1 : -1;
                }
            }
        }
        return c;
    }
}

