/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.sis.referencing.operation.transform.MolodenskyTransform;
import org.apache.sis.referencing.operation.transform.MolodenskyTransform2D;
import org.opengis.referencing.datum.Ellipsoid;

final class AbridgedMolodenskyTransform2D
extends MolodenskyTransform2D {
    private static final long serialVersionUID = -7732503837408555590L;
    private transient double scale;

    AbridgedMolodenskyTransform2D(Ellipsoid source, Ellipsoid target) {
        super(source, target, 0.0, 0.0, 0.0, true);
        this.computeTransientFields();
    }

    AbridgedMolodenskyTransform2D(MolodenskyTransform inverse, Ellipsoid source, Ellipsoid target) {
        super(inverse, source, target);
        this.computeTransientFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.computeTransientFields();
    }

    private void computeTransientFields() {
        this.scale = 2.000000000007835 * this.\u0394fmod / (this.semiMajor * (1.0 - this.eccentricitySquared));
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
        while (--numPts >= 0) {
            double \u03c6 = dstPts[++dstOff];
            double sin\u03c6 = Math.sin(\u03c6);
            double cos\u03c6 = Math.cos(\u03c6);
            double \u03c1 = 1.0 - this.eccentricitySquared * (sin\u03c6 * sin\u03c6);
            \u03c1 *= Math.sqrt(\u03c1);
            dstPts[dstOff++] = \u03c6 + this.scale * (cos\u03c6 * sin\u03c6) * \u03c1;
        }
    }
}

