/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.ucar;

import java.util.Collection;
import java.util.List;
import org.apache.sis.storage.netcdf.base.Dimension;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.UnmodifiableArrayList;

final class DimensionWrapper
extends Dimension {
    private final ucar.nc2.Dimension netcdf;
    private final int index;

    static List<Dimension> wrap(Collection<ucar.nc2.Dimension> dimensions) {
        DimensionWrapper[] wrappers = new DimensionWrapper[dimensions.size()];
        int i = 0;
        for (ucar.nc2.Dimension dim : dimensions) {
            wrappers[i] = new DimensionWrapper(dim, i);
            ++i;
        }
        return UnmodifiableArrayList.wrap((Dimension[])ArraysExt.resize(wrappers, i));
    }

    static ucar.nc2.Dimension[] unwrap(Dimension[] dimensions) {
        ucar.nc2.Dimension[] ncd = new ucar.nc2.Dimension[dimensions.length];
        for (int i = 0; i < ncd.length; ++i) {
            ncd[i] = ((DimensionWrapper)dimensions[i]).netcdf;
        }
        return ncd;
    }

    DimensionWrapper(ucar.nc2.Dimension netcdf, int index) {
        this.netcdf = netcdf;
        this.index = index;
    }

    @Override
    public String getName() {
        return this.netcdf.getShortName();
    }

    @Override
    public long length() {
        return this.netcdf.getLength();
    }

    @Override
    protected boolean isUnlimited() {
        return this.netcdf.isUnlimited();
    }

    @Override
    protected Dimension decrementIndex() {
        return new DimensionWrapper(this.netcdf, this.index - 1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DimensionWrapper) {
            DimensionWrapper other = (DimensionWrapper)obj;
            if (this.netcdf.equals(other.netcdf)) {
                return this.netcdf.isShared() || other.index == this.index;
            }
        }
        return false;
    }

    public int hashCode() {
        int code = ~this.netcdf.hashCode();
        if (!this.netcdf.isShared()) {
            code += 37 * this.index;
        }
        return code;
    }
}

