/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.LocalBarrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.SideEffectCapable;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.BulkSetSupplier;

public final class AggregateGlobalStep<S>
extends AbstractStep<S, S>
implements SideEffectCapable<Collection, Collection>,
TraversalParent,
ByModulating,
LocalBarrier<S> {
    private Traversal.Admin<S, Object> aggregateTraversal = null;
    private String sideEffectKey;
    private TraverserSet<S> barrier;

    public AggregateGlobalStep(Traversal.Admin traversal, String sideEffectKey) {
        super(traversal);
        this.sideEffectKey = sideEffectKey;
        this.barrier = this.traversal.getTraverserSetSupplier().get();
        this.getTraversal().getSideEffects().registerIfAbsent(this.sideEffectKey, BulkSetSupplier.instance(), Operator.addAll);
    }

    @Override
    public String getSideEffectKey() {
        return this.sideEffectKey;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.sideEffectKey, this.aggregateTraversal);
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> aggregateTraversal) {
        this.aggregateTraversal = this.integrateChild(aggregateTraversal);
    }

    @Override
    public void replaceLocalChild(Traversal.Admin<?, ?> oldTraversal, Traversal.Admin<?, ?> newTraversal) {
        if (null != this.aggregateTraversal && this.aggregateTraversal.equals(oldTraversal)) {
            this.aggregateTraversal = this.integrateChild(newTraversal);
        }
    }

    public List<Traversal.Admin<S, Object>> getLocalChildren() {
        return null == this.aggregateTraversal ? Collections.emptyList() : Collections.singletonList(this.aggregateTraversal);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.BULK, TraverserRequirement.SIDE_EFFECTS);
    }

    @Override
    public AggregateGlobalStep<S> clone() {
        AggregateGlobalStep clone = (AggregateGlobalStep)super.clone();
        clone.barrier = this.traversal.getTraverserSetSupplier().get();
        if (null != this.aggregateTraversal) {
            clone.aggregateTraversal = this.aggregateTraversal.clone();
        }
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.aggregateTraversal);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode() ^ this.sideEffectKey.hashCode();
        if (this.aggregateTraversal != null) {
            result ^= this.aggregateTraversal.hashCode();
        }
        return result;
    }

    @Override
    protected Traverser.Admin<S> processNextStart() {
        if (this.barrier.isEmpty()) {
            this.processAllStarts();
        }
        return this.barrier.remove();
    }

    @Override
    public void processAllStarts() {
        boolean bulkReducingOperator;
        TraversalSideEffects sideEffects = this.getTraversal().getSideEffects();
        boolean bl = bulkReducingOperator = sideEffects.getReducer(this.sideEffectKey) == Operator.addAll || sideEffects.getReducer(this.sideEffectKey) == Operator.assign;
        if (this.starts.hasNext()) {
            BulkSet bulkSet = new BulkSet();
            while (this.starts.hasNext()) {
                Object traverser = this.starts.next();
                TraversalUtil.produce(traverser, this.aggregateTraversal).ifProductive(arg_0 -> AggregateGlobalStep.lambda$processAllStarts$0(bulkSet, (Traverser.Admin)traverser, arg_0));
                traverser.setStepId(this.getNextStep().getId());
                this.barrier.add((Traverser.Admin<S>)traverser);
            }
            if (bulkReducingOperator) {
                sideEffects.add(this.sideEffectKey, bulkSet);
            } else {
                bulkSet.forEach(p -> sideEffects.add(this.sideEffectKey, p));
            }
        }
    }

    @Override
    public boolean hasNextBarrier() {
        if (this.barrier.isEmpty()) {
            this.processAllStarts();
        }
        return !this.barrier.isEmpty();
    }

    @Override
    public TraverserSet<S> nextBarrier() throws NoSuchElementException {
        if (this.barrier.isEmpty()) {
            this.processAllStarts();
        }
        if (this.barrier.isEmpty()) {
            throw FastNoSuchElementException.instance();
        }
        TraverserSet<S> temp = this.barrier;
        this.barrier = this.traversal.getTraverserSetSupplier().get();
        return temp;
    }

    @Override
    public void addBarrier(TraverserSet<S> barrier) {
        this.barrier.addAll(barrier);
    }

    @Override
    public void reset() {
        super.reset();
        this.barrier.clear();
    }

    private static /* synthetic */ void lambda$processAllStarts$0(BulkSet bulkSet, Traverser.Admin traverser, Object p) {
        bulkSet.add(p, traverser.bulk());
    }
}

