/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.GraphWriter;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.util.star.DirectionalStarGraph;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraph;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;

public final class GraphSONWriter
implements GraphWriter {
    private final ObjectMapper mapper;
    private final boolean wrapAdjacencyList;

    private GraphSONWriter(Builder builder) {
        this.mapper = (ObjectMapper)builder.mapper.createMapper();
        this.wrapAdjacencyList = builder.wrapAdjacencyList;
    }

    @Override
    public void writeGraph(OutputStream outputStream, Graph g) throws IOException {
        this.writeVertices(outputStream, g.vertices(new Object[0]), Direction.BOTH);
    }

    @Override
    public void writeVertex(OutputStream outputStream, Vertex v, Direction direction) throws IOException {
        this.mapper.writeValue(outputStream, (Object)new DirectionalStarGraph(StarGraph.of(v), direction));
    }

    @Override
    public void writeVertex(OutputStream outputStream, Vertex v) throws IOException {
        this.writeVertex(outputStream, v, null);
    }

    @Override
    public void writeVertices(OutputStream outputStream, Iterator<Vertex> vertexIterator, Direction direction) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            if (this.wrapAdjacencyList) {
                writer.write("{\"vertices\":[");
            }
            while (vertexIterator.hasNext()) {
                this.writeVertex(baos, vertexIterator.next(), direction);
                writer.write(new String(baos.toByteArray()));
                if (this.wrapAdjacencyList) {
                    if (vertexIterator.hasNext()) {
                        writer.write(",");
                    }
                } else {
                    writer.newLine();
                }
                baos.reset();
            }
            if (this.wrapAdjacencyList) {
                writer.write("]}");
            }
        }
        writer.flush();
    }

    @Override
    public void writeVertices(OutputStream outputStream, Iterator<Vertex> vertexIterator) throws IOException {
        this.writeVertices(outputStream, vertexIterator, null);
    }

    @Override
    public void writeEdge(OutputStream outputStream, Edge e) throws IOException {
        this.mapper.writeValue(outputStream, (Object)e);
    }

    @Override
    public void writeVertexProperty(OutputStream outputStream, VertexProperty vp) throws IOException {
        this.mapper.writeValue(outputStream, (Object)vp);
    }

    @Override
    public void writeProperty(OutputStream outputStream, Property p) throws IOException {
        this.mapper.writeValue(outputStream, (Object)p);
    }

    @Override
    public void writeObject(OutputStream outputStream, Object object) throws IOException {
        this.mapper.writeValue(outputStream, object);
    }

    public static Builder build() {
        return new Builder();
    }

    public static class Builder
    implements GraphWriter.WriterBuilder<GraphSONWriter> {
        private Mapper<ObjectMapper> mapper = GraphSONMapper.build().create();
        private boolean wrapAdjacencyList = false;

        private Builder() {
        }

        public Builder mapper(Mapper<ObjectMapper> mapper) {
            this.mapper = mapper;
            return this;
        }

        public Builder wrapAdjacencyList(boolean wrapAdjacencyListInObject) {
            this.wrapAdjacencyList = wrapAdjacencyListInObject;
            return this;
        }

        @Override
        public GraphSONWriter create() {
            return new GraphSONWriter(this);
        }
    }
}

