/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.tinkerpop.gremlin.algorithm.generator;

import java.util.Random;

/**
 * CopyDistribution returns the conditional value.
 * <p/>
 * Hence, this class can be used as the in-degree distribution to ensure that
 * the in-degree of a vertex is equal to the out-degree.
 *
 * @author Matthias Broecheler (me@matthiasb.com)
 */
public class CopyDistribution implements Distribution {

    @Override
    public Distribution initialize(final int invocations, final int expectedTotal) {
        return this;
    }

    @Override
    public int nextValue(final Random random) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nextConditionalValue(final Random random, final int otherValue) {
        return otherValue;
    }
}
