/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.websocket.Extension;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Constants;
import org.apache.tomcat.websocket.PerMessageDeflate;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.TransformationBuilder;

public class TransformationFactory {
    private static final StringManager sm = StringManager.getManager(TransformationFactory.class);
    private static final TransformationFactory factory = new TransformationFactory();
    private Map<String, TransformationBuilder> builders = new HashMap<String, TransformationBuilder>();

    private TransformationFactory() {
        this.builders.put("permessage-deflate", PerMessageDeflate.BUILDER);
    }

    public static TransformationFactory getInstance() {
        return factory;
    }

    public Transformation create(String name, List<List<Extension.Parameter>> preferences, boolean isServer) {
        TransformationBuilder builder = this.builders.get(name);
        if (builder != null) {
            return builder.build(preferences, isServer);
        }
        if (Constants.ALLOW_UNSUPPORTED_EXTENSIONS) {
            return null;
        }
        throw new IllegalArgumentException(sm.getString("transformerFactory.unsupportedExtension", new Object[]{name}));
    }

    public void registerExtension(String name, TransformationBuilder builder) {
        this.builders.put(name, builder);
    }
}

