/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.jaxrs;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.Tag;

public class JaxRsMetricsFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    @Context
    ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext) {
        MetricID metricID = this.getMetricID(this.resourceInfo.getResourceClass(), this.resourceInfo.getResourceMethod());
        requestContext.setProperty("smallrye.metrics.jaxrs.metricID", (Object)metricID);
    }

    private MetricID getMetricID(Class<?> resourceClass, Method resourceMethod) {
        Tag classTag = new Tag("class", resourceClass.getName());
        String methodName = resourceMethod.getName();
        String encodedParameterNames = Arrays.stream(resourceMethod.getParameterTypes()).map(clazz -> {
            if (clazz.isArray()) {
                return clazz.getComponentType().getName() + "[]";
            }
            return clazz.getName();
        }).collect(Collectors.joining("_"));
        String methodTagValue = encodedParameterNames.isEmpty() ? methodName : methodName + "_" + encodedParameterNames;
        Tag methodTag = new Tag("method", methodTagValue);
        return new MetricID("REST.request", new Tag[]{classTag, methodTag});
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        requestContext.setProperty("smallrye.metrics.jaxrs.successful", (Object)true);
    }
}

