/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification.diff;

import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.verification.diff.Diff;
import com.github.tomakehurst.wiremock.verification.diff.DiffLine;
import wiremock.org.apache.commons.lang3.StringUtils;

public class PlainTextDiffRenderer {
    private final int consoleWidth;

    public PlainTextDiffRenderer() {
        this(119);
    }

    public PlainTextDiffRenderer(int consoleWidth) {
        this.consoleWidth = consoleWidth;
    }

    public String render(Diff diff) {
        StringBuilder sb = new StringBuilder();
        this.header(sb);
        if (diff.getStubMappingName() != null) {
            this.writeLine(sb, diff.getStubMappingName(), "", null);
            this.writeBlankLine(sb);
        }
        for (DiffLine<?> line : diff.getLines()) {
            boolean isBodyLine = line.getRequestAttribute().equals("Body");
            if (isBodyLine && !line.isForNonMatch()) continue;
            this.writeLine(sb, line.getPrintedPatternValue(), line.getActual().toString(), line.getMessage());
        }
        this.writeBlankLine(sb);
        this.footer(sb);
        return sb.toString();
    }

    private void header(StringBuilder sb) {
        String titleLine = "Request was not matched";
        int middle = this.getMiddle();
        int titleLinePaddingLeft = middle - titleLine.length() / 2;
        sb.append('\n').append(StringUtils.repeat(' ', titleLinePaddingLeft)).append(titleLine).append('\n').append(StringUtils.repeat(' ', titleLinePaddingLeft)).append(StringUtils.repeat('=', titleLine.length())).append('\n').append('\n').append(StringUtils.repeat('-', this.consoleWidth)).append('\n').append('|').append(StringUtils.rightPad(" Closest stub", middle)).append('|').append(StringUtils.rightPad(" Request", middle, ' ')).append('|').append('\n').append(StringUtils.repeat('-', this.consoleWidth)).append('\n');
        this.writeBlankLine(sb);
    }

    private void footer(StringBuilder sb) {
        sb.append(StringUtils.repeat('-', this.consoleWidth)).append('\n');
    }

    private void writeLine(StringBuilder sb, String left, String right, String message) {
        String[] leftLines = this.wrap(left).split("\n");
        String[] rightLines = this.wrap(right).split("\n");
        int maxLines = Math.max(leftLines.length, rightLines.length);
        this.writeSingleLine(sb, leftLines[0], rightLines[0], message);
        if (maxLines > 1) {
            for (int i = 1; i < maxLines; ++i) {
                String leftPart = leftLines.length > i ? leftLines[i] : "";
                String rightPart = rightLines.length > i ? rightLines[i] : "";
                this.writeSingleLine(sb, leftPart, rightPart, null);
            }
        }
    }

    private void writeBlankLine(StringBuilder sb) {
        this.writeSingleLine(sb, "", null, null);
    }

    private void writeSingleLine(StringBuilder sb, String left, String right) {
        this.writeSingleLine(sb, left, right, null);
    }

    private void writeSingleLine(StringBuilder sb, String left) {
        this.writeSingleLine(sb, left, null);
    }

    private void writeSingleLine(StringBuilder sb, String left, String right, String message) {
        sb.append("").append(StringUtils.rightPad(left, this.getMiddle() + 1, " ")).append("|");
        if (StringUtils.isNotEmpty(right)) {
            sb.append(" ");
            if (StringUtils.isNotEmpty(message)) {
                sb.append(StringUtils.rightPad(right, this.getMiddle() - 6, " ")).append("<<<<< ").append(message);
            } else {
                sb.append(right);
            }
        } else if (StringUtils.isNotEmpty(message)) {
            sb.append(StringUtils.rightPad(right, this.getMiddle() - 5, " ")).append("<<<<< ").append(message);
        }
        sb.append("\n");
    }

    private String wrap(String s) {
        return Strings.wrapIfLongestLineExceedsLimit(s, this.getColumnWidth());
    }

    private int getColumnWidth() {
        return this.consoleWidth / 2 - 2;
    }

    private int getMiddle() {
        return this.consoleWidth / 2 - 1;
    }
}

