/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.parser;

import java.net.URLDecoder;
import java.util.StringTokenizer;
import org.apache.fulcrum.parser.BaseValueParser;

public class StringValueParser
extends BaseValueParser {
    public void parse(String s, char delim, boolean urlDecode) throws Exception {
        String delimChar = String.valueOf(delim);
        StringTokenizer st = new StringTokenizer(s, delimChar);
        boolean isNameTok = true;
        String pathPart = null;
        String key = null;
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (urlDecode) {
                tok = URLDecoder.decode(tok, this.getCharacterEncoding());
            }
            if (isNameTok) {
                key = tok;
                isNameTok = false;
                continue;
            }
            pathPart = tok;
            if (key != null && key.length() > 0) {
                this.add(this.convert(key), pathPart);
            }
            isNameTok = true;
        }
    }

    public void parse(String s, char paramDelim, char pairDelim, boolean urlDecode) throws Exception {
        if (paramDelim == pairDelim) {
            this.parse(s, paramDelim, urlDecode);
        } else {
            String delimChar = String.valueOf(paramDelim);
            StringTokenizer st = new StringTokenizer(s, delimChar);
            while (st.hasMoreTokens()) {
                String pair = st.nextToken();
                int pos = pair.indexOf(pairDelim);
                String name = pair.substring(0, pos);
                String value = pair.substring(pos + 1);
                if (urlDecode) {
                    name = URLDecoder.decode(name, this.getCharacterEncoding());
                    value = URLDecoder.decode(value, this.getCharacterEncoding());
                }
                if (name.length() <= 0) continue;
                this.add(this.convert(name), value);
            }
        }
    }
}

