/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.outline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.outline.AnnotationTreeNode;

public class AnnotationTreeNodeList {
    private List<AnnotationTreeNode> mElements = new ArrayList<AnnotationTreeNode>();
    private ICasDocument mDocument;

    AnnotationTreeNodeList(ICasDocument document) {
        this.mDocument = document;
    }

    AnnotationTreeNodeList(ICasDocument document, Collection<AnnotationFS> annotations) {
        this.mDocument = document;
        for (AnnotationFS annotation : annotations) {
            this.mElements.add(new AnnotationTreeNode(this.mDocument, annotation));
        }
    }

    List<AnnotationTreeNode> getElements() {
        return this.mElements;
    }

    void add(AnnotationTreeNode node) {
        this.mElements.add(node);
    }

    void remove(AnnotationTreeNode node) {
        if (this.mElements.contains(node)) {
            // empty if block
        }
        this.mElements.remove(node);
    }

    void buildTree() {
        Iterator<AnnotationTreeNode> it = this.mElements.iterator();
        while (it.hasNext()) {
            AnnotationTreeNode aNode = it.next();
            boolean isMoved = false;
            for (AnnotationTreeNode bNode : this.mElements) {
                if (aNode == bNode || !bNode.isChild(aNode)) continue;
                bNode.addChild(aNode);
                isMoved = true;
                break;
            }
            if (!isMoved) continue;
            it.remove();
        }
    }
}

