/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ep_launcher;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.uima.ep_launcher.LauncherConstants;
import org.apache.uima.ep_launcher.LauncherPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.osgi.framework.Bundle;

public class AnalysisEngineLaunchConfigurationDelegate
extends JavaLaunchDelegate {
    public String getMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        return "org.apache.uima.ep_launcher.RemoteLauncher";
    }

    private String pluginIdToJarPath(String pluginId) throws IOException {
        Bundle bundle = LauncherPlugin.getDefault().getBundle(pluginId);
        URL url = bundle.getEntry("/");
        if (url == null) {
            throw new IOException();
        }
        return FileLocator.toFileURL((URL)url).getFile();
    }

    private static void ensureResourceExists(IResource resource, String resourceName) throws CoreException {
        if (resource == null) {
            throw new CoreException((IStatus)new Status(4, "org.apache.uima.launcher", "The " + resourceName + " does not exist!"));
        }
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        String pgmArgs;
        StringBuilder cmdline = new StringBuilder();
        cmdline.append("-descriptor ");
        String descriptorPath = configuration.getAttribute("org.apache.uima.ep_launcher.DESCRIPTOR_ATTR", "");
        IResource descriptor = ResourcesPlugin.getWorkspace().getRoot().findMember(descriptorPath);
        AnalysisEngineLaunchConfigurationDelegate.ensureResourceExists(descriptor, "Analysis Engine Descritpor");
        cmdline.append(descriptor.getLocation().toOSString() + " ");
        cmdline.append("-inputResource ");
        String inputResourcePath = configuration.getAttribute("org.apache.uima.ep_launcher.INPUT_ATTR", "");
        IResource inputResource = ResourcesPlugin.getWorkspace().getRoot().findMember(inputResourcePath);
        AnalysisEngineLaunchConfigurationDelegate.ensureResourceExists(inputResource, "Input Resource");
        cmdline.append(inputResource.getLocation().toOSString() + " ");
        String formatName = configuration.getAttribute("org.apache.uima.ep_launcher.INPUT_FORMAT_ATTR", " ");
        cmdline.append("-format ");
        cmdline.append(formatName + " ");
        if (LauncherConstants.InputFormat.PLAIN_TEXT.toString().equals(formatName)) {
            cmdline.append("-encoding ");
            cmdline.append(configuration.getAttribute("org.apache.uima.ep_launcher.INPUT_ENCODING_ATTR", "") + " ");
            cmdline.append("-language ");
            cmdline.append(configuration.getAttribute("org.apache.uima.ep_launcher.INPUT_LANGUAGE_ATTR", "") + " ");
        }
        cmdline.append("-recursive ");
        cmdline.append(configuration.getAttribute("org.apache.uima.ep_launcher.INPUT_RECURSIVELY_ATTR", false) + " ");
        String outputFolderPath = configuration.getAttribute("org.apache.uima.ep_launcher.OUTPUT_FOLDER_ATTR", "");
        if (outputFolderPath.length() != 0) {
            IResource outputFolder = ResourcesPlugin.getWorkspace().getRoot().findMember(outputFolderPath);
            AnalysisEngineLaunchConfigurationDelegate.ensureResourceExists(outputFolder, "Output Folder");
            cmdline.append("-output ");
            cmdline.append(outputFolder.getLocation().toOSString() + " ");
            if (!(outputFolder instanceof IWorkspaceRoot) && !(outputFolder instanceof IProject)) {
                cmdline.append("-clear ");
                cmdline.append(configuration.getAttribute("org.apache.uima.ep_launcher.OUTPUT_CLEAR_ATTR", false));
            }
        }
        if ((pgmArgs = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "")) != null) {
            cmdline.append(' ').append(pgmArgs);
        }
        return cmdline.toString();
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<Object> extendedClasspath = new ArrayList<Object>();
        Collections.addAll(extendedClasspath, super.getClasspath(configuration));
        try {
            if (!Platform.inDevelopmentMode()) {
                extendedClasspath.add(this.pluginIdToJarPath("org.apache.uima.launcher"));
            } else {
                extendedClasspath.add(this.pluginIdToJarPath("org.apache.uima.launcher") + "target/classes");
            }
            Bundle bundle = LauncherPlugin.getDefault().getBundle("org.apache.uima.runtime");
            if (bundle != null) {
                Enumeration jarEnum = bundle.findEntries("/", "uimaj-core*.jar", Platform.inDevelopmentMode());
                while (jarEnum != null && jarEnum.hasMoreElements()) {
                    URL element = (URL)jarEnum.nextElement();
                    extendedClasspath.add(FileLocator.toFileURL((URL)element).getFile());
                }
            }
            extendedClasspath.add(this.pluginIdToJarPath("org.apache.uima.runtime"));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.apache.uima.launcher", 0, "Failed to compose classpath!", (Throwable)e));
        }
        return extendedClasspath.toArray(new String[extendedClasspath.size()]);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IResource result;
        super.launch(configuration, mode, launch, monitor);
        while (!launch.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        String outputFolderPath = configuration.getAttribute("org.apache.uima.ep_launcher.OUTPUT_FOLDER_ATTR", "");
        if (outputFolderPath.length() != 0 && (result = ResourcesPlugin.getWorkspace().getRoot().findMember(outputFolderPath)) != null) {
            result.refreshLocal(2, null);
        }
    }
}

