/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.deployment.impl;

import java.util.List;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.deployment.AEDeploymentConstants;
import org.apache.uima.aae.deployment.AEDeploymentMetaData;
import org.apache.uima.aae.deployment.AsyncAEErrorConfiguration;
import org.apache.uima.aae.deployment.AsyncAggregateErrorConfiguration;
import org.apache.uima.aae.deployment.AsyncPrimitiveErrorConfiguration;
import org.apache.uima.aae.deployment.RemoteAEDeploymentMetaData;
import org.apache.uima.aae.deployment.impl.AEDelegates_Impl;
import org.apache.uima.aae.deployment.impl.AEDeploymentDescription_Impl;
import org.apache.uima.aae.deployment.impl.DDEInvalidXMLException;
import org.apache.uima.aae.deployment.impl.DDParserUtil;
import org.apache.uima.aae.deployment.impl.DeploymentMetaData_Impl;
import org.apache.uima.aae.deployment.impl.RemoteAEDeploymentMetaData_Impl;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.tools.debug.util.Trace;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLParser;
import org.apache.uima.util.XMLizable;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AEDeploymentMetaData_Impl
extends DeploymentMetaData_Impl
implements AEDeploymentConstants,
AEDeploymentMetaData {
    protected boolean topAnalysisEngine = false;
    protected boolean async = false;
    protected boolean issetAsync = false;
    protected int numberOfInstances = 1;
    protected boolean casMultiplier = false;
    protected int casMultiplierPoolSize = 1;
    protected int initialFsHeapSize = 2000000;
    protected boolean processParentCASLast = false;
    protected AEDelegates_Impl delegates;
    protected AsyncAEErrorConfiguration asyncAEErrorConfiguration;
    protected ResourceSpecifier resourceSpecifier;
    protected Import importedAE;
    protected int inputQueueScaleout = -1;
    protected int internalReplyQueueScaleout = -1;
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("analysisEngine", new PropertyXmlInfo[]{new PropertyXmlInfo("cpeDescriptor", false), new PropertyXmlInfo("defaultCasProcessorSettings", false)});

    @Override
    public boolean isSet(int i) {
        return i != -1;
    }

    @Override
    public ResourceSpecifier getResourceSpecifier() {
        return this.resourceSpecifier;
    }

    @Override
    public void setResourceSpecifier(ResourceSpecifier rs, ResourceManager aResourceManager, boolean recursive) throws InvalidXMLException {
        this.resourceSpecifier = rs;
        this.setCasMultiplier(AEDeploymentDescription_Impl.isCASMultiplier(rs));
        if (rs instanceof AnalysisEngineDescription && recursive) {
            this.resolveDelegatesInternal((AnalysisEngineDescription)rs, aResourceManager, recursive);
        }
    }

    @Override
    public void resolveDelegates(ResourceManager aResourceManager, boolean recursive) throws InvalidXMLException {
        if (this.getResourceSpecifier() == null) {
            Trace.err(this.getKey() + ": NO AnalysisEngineDescription");
            return;
        }
        ResourceSpecifier rs1 = this.getResourceSpecifier();
        if (!(rs1 instanceof AnalysisEngineDescription)) {
            return;
        }
        AnalysisEngineDescription aed = (AnalysisEngineDescription)rs1;
        aed.resolveImports(aResourceManager);
        Map mapDelegateAEs = aed.getDelegateAnalysisEngineSpecifiers(aResourceManager);
        if (this.delegates != null) {
            for (String string : this.delegates.delegateKeys) {
                if (mapDelegateAEs.containsKey(string)) continue;
                Trace.err(" >>> " + string + " is not in" + aed.getAnalysisEngineMetaData().getName());
                throw new DDEInvalidXMLException("delegate_key_not_found", new Object[]{string, aed.getSourceUrlString()});
            }
        } else {
            this.delegates = new AEDelegates_Impl(this);
        }
        for (Object object : mapDelegateAEs.entrySet()) {
            Object obj;
            Map.Entry entry = (Map.Entry)object;
            XMLizable xmlizable = this.delegates.contains((String)entry.getKey());
            if (xmlizable != null) {
                if (xmlizable instanceof AEDeploymentMetaData) {
                    if (entry.getValue() instanceof Import) {
                        ((AEDeploymentMetaData)xmlizable).setImportedAE((Import)entry.getValue());
                        Trace.bug("Import should be resolved for: " + ((Import)entry.getValue()).getName());
                        continue;
                    }
                    ((AEDeploymentMetaData)xmlizable).setResourceSpecifier((ResourceSpecifier)entry.getValue(), aResourceManager, recursive);
                    continue;
                }
                if (!(xmlizable instanceof RemoteAEDeploymentMetaData)) continue;
                if (entry.getValue() instanceof Import) {
                    ((RemoteAEDeploymentMetaData)xmlizable).setImportedAE((Import)entry.getValue());
                    Trace.bug("Import should be resolved for: " + ((Import)entry.getValue()).getName());
                    continue;
                }
                ((RemoteAEDeploymentMetaData)xmlizable).setResourceSpecifier((ResourceSpecifier)entry.getValue(), aResourceManager, recursive);
                continue;
            }
            AEDeploymentMetaData_Impl meta = new AEDeploymentMetaData_Impl();
            meta.setKey((String)entry.getKey());
            if (entry.getValue() instanceof ResourceSpecifier) {
                meta.setResourceSpecifier((ResourceSpecifier)entry.getValue(), aResourceManager, recursive);
            }
            if ((obj = UIMAFramework.getResourceSpecifierFactory().createObject(AsyncAggregateErrorConfiguration.class)) != null) {
                ((AsyncAEErrorConfiguration)obj).getGetMetadataErrors().setTimeout(0);
                meta.setAsyncAEErrorConfiguration((AsyncAEErrorConfiguration)obj);
            } else {
                Trace.err("CANNOT create " + AsyncAggregateErrorConfiguration.class.getName() + " for " + meta.getKey());
            }
            this.delegates.addDelegate(meta);
        }
    }

    protected void resolveDelegatesInternal(AnalysisEngineDescription aeDescription, ResourceManager aResourceManager, boolean recursive) throws InvalidXMLException {
        if (aeDescription.isPrimitive()) {
            return;
        }
        if (this.getDelegates() == null) {
            return;
        }
        Map mapDelegateAEs = aeDescription.getDelegateAnalysisEngineSpecifiers(aResourceManager);
        List<XMLizable> list = this.getDelegates().getDelegates();
        for (XMLizable xmlizable : list) {
            ResourceSpecifier rs;
            Object meta;
            if (xmlizable instanceof AEDeploymentMetaData) {
                meta = (AEDeploymentMetaData)xmlizable;
                if (mapDelegateAEs.containsKey(meta.getKey())) {
                    rs = (ResourceSpecifier)mapDelegateAEs.get(meta.getKey());
                    meta.setResourceSpecifier(rs, aResourceManager, recursive);
                    continue;
                }
                throw new DDEInvalidXMLException("delegate_key_not_found", new Object[]{meta.getKey(), aeDescription.getSourceUrlString()});
            }
            if (!(xmlizable instanceof RemoteAEDeploymentMetaData)) continue;
            meta = (RemoteAEDeploymentMetaData)xmlizable;
            if (mapDelegateAEs.containsKey(meta.getKey())) {
                rs = (ResourceSpecifier)mapDelegateAEs.get(meta.getKey());
                meta.setResourceSpecifier(rs, aResourceManager, recursive);
                continue;
            }
            Trace.err("NOT Match: " + meta.getKey());
            throw new DDEInvalidXMLException("delegate_key_not_found", new Object[]{meta.getKey(), aeDescription.getSourceUrlString()});
        }
    }

    @Override
    public void buildFromXMLElement(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        NamedNodeMap map;
        boolean isTopAnalysisEngine = false;
        if (aElement.getParentNode() instanceof Element) {
            if (((Element)aElement.getParentNode()).getTagName().equalsIgnoreCase("service")) {
                isTopAnalysisEngine = true;
            }
        } else {
            Trace.bug("Not an Element class: " + aElement.getParentNode().getClass().getName());
        }
        if ((map = aElement.getAttributes()) != null) {
            for (int i = 0; i < map.getLength(); ++i) {
                int n;
                Node item = map.item(i);
                String name = item.getNodeName();
                String val = item.getNodeValue();
                val = val == null ? "" : val.trim();
                if ("key".equalsIgnoreCase(name)) {
                    this.setKey(val);
                    continue;
                }
                if ("async".equalsIgnoreCase(name)) {
                    this.setAsync(Boolean.parseBoolean(val));
                    continue;
                }
                if ("inputQueueScaleout".equalsIgnoreCase(name)) {
                    try {
                        n = Integer.parseInt(val);
                        if (n <= 0) {
                            throw new InvalidXMLException("invalid_element_text", new Object[]{n, "inputQueueScaleout"});
                        }
                        this.setInputQueueScaleout(n);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new InvalidXMLException("unknown_element", new Object[]{"inputQueueScaleout"}, (Throwable)e);
                    }
                }
                if ("internalReplyQueueScaleout".equalsIgnoreCase(name)) {
                    try {
                        n = Integer.parseInt(val);
                        if (n <= 0) {
                            throw new InvalidXMLException("invalid_element_text", new Object[]{n, "internalReplyQueueScaleout"});
                        }
                        this.setInternalReplyQueueScaleout(n);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new InvalidXMLException("unknown_element", new Object[]{"internalReplyQueueScaleout"}, (Throwable)e);
                    }
                }
                throw new InvalidXMLException("unknown_element", new Object[]{name});
            }
            if (!this.isAsync()) {
                if (this.getInputQueueScaleout() > 1) {
                    throw new InvalidXMLException("invalid_element_text", new Object[]{this.getInputQueueScaleout(), "inputQueueScaleout"});
                }
                if (this.getInternalReplyQueueScaleout() > 1) {
                    throw new InvalidXMLException("invalid_element_text", new Object[]{this.getInternalReplyQueueScaleout(), "internalReplyQueueScaleout"});
                }
            }
        }
        if (!isTopAnalysisEngine && this.getKey() == null) {
            throw new InvalidXMLException("element_not_found", new Object[]{"key", "analysisEngine"});
        }
        NodeList childNodes = aElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String val;
            Node curNode = childNodes.item(i);
            if (!(curNode instanceof Element)) continue;
            Element elem = (Element)curNode;
            if ("scaleout".equalsIgnoreCase(elem.getTagName())) {
                int n;
                val = DDParserUtil.checkAndGetAttributeValue("scaleout", "numberOfInstances", elem, true);
                if (val == null || val.trim().length() == 0) {
                    n = 0;
                } else {
                    try {
                        n = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        throw new InvalidXMLException("unknown_element", new Object[]{"numberOfInstances"}, (Throwable)e);
                    }
                }
                this.setNumberOfInstances(n);
                continue;
            }
            if ("casMultiplier".equalsIgnoreCase(elem.getTagName())) {
                int n;
                val = DDParserUtil.checkAndGetAttributeValue("casMultiplier", "poolSize", elem, true);
                if (val == null || val.trim().length() == 0) {
                    n = 0;
                } else {
                    try {
                        n = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        throw new InvalidXMLException("unknown_element", new Object[]{"poolSize"}, (Throwable)e);
                    }
                }
                this.setCasMultiplierPoolSize(n);
                val = DDParserUtil.checkAndGetAttributeValue("casMultiplier", "initialFsHeapSize", elem, false);
                if (val != null && val.trim().length() > 0) {
                    try {
                        this.initialFsHeapSize = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        throw new InvalidXMLException("unknown_element", new Object[]{"initialFsHeapSize"}, (Throwable)e);
                    }
                }
                val = DDParserUtil.checkAndGetAttributeValue("casMultiplier", "processParentLast", elem, false);
                boolean b = false;
                if (val != null && val.trim().length() > 0) {
                    try {
                        b = Boolean.parseBoolean(val);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        throw new InvalidXMLException("unknown_element", new Object[]{"processParentLast"}, (Throwable)e);
                    }
                }
                this.setProcessParentCASLast(b);
                continue;
            }
            if ("delegates".equalsIgnoreCase(elem.getTagName())) {
                this.delegates = new AEDelegates_Impl(this);
                NodeList nodes = elem.getChildNodes();
                if (nodes.getLength() <= 0) continue;
                for (int k = 0; k < nodes.getLength(); ++k) {
                    Node n = nodes.item(k);
                    if (!(n instanceof Element)) continue;
                    Element e = (Element)n;
                    if ("analysisEngine".equalsIgnoreCase(e.getTagName())) {
                        this.delegates.addDelegate((DeploymentMetaData_Impl)aParser.buildObject(e, aOptions));
                        continue;
                    }
                    if (!"remoteAnalysisEngine".equalsIgnoreCase(e.getTagName())) continue;
                    this.delegates.addDelegate((DeploymentMetaData_Impl)aParser.buildObject(e, aOptions));
                }
                continue;
            }
            if ("asyncPrimitiveErrorConfiguration".equalsIgnoreCase(elem.getTagName())) {
                this.asyncAEErrorConfiguration = (AsyncPrimitiveErrorConfiguration)aParser.buildObject(elem, aOptions);
                this.asyncAEErrorConfiguration.sParentObject(this);
                continue;
            }
            if ("asyncAggregateErrorConfiguration".equalsIgnoreCase(elem.getTagName())) {
                this.asyncAEErrorConfiguration = (AsyncAggregateErrorConfiguration)aParser.buildObject(elem, aOptions);
                this.asyncAEErrorConfiguration.sParentObject(this);
                continue;
            }
            throw new InvalidXMLException("unknown_element", new Object[]{elem.getTagName()});
        }
        if (!this.isAsync() && this.delegates != null) {
            this.setAsync(true);
        }
        if (this.asyncAEErrorConfiguration == null) {
            Class cls = isTopAnalysisEngine ? AsyncPrimitiveErrorConfiguration.class : AsyncAggregateErrorConfiguration.class;
            this.asyncAEErrorConfiguration = (AsyncAEErrorConfiguration)UIMAFramework.getResourceSpecifierFactory().createObject(cls);
            this.setAsyncAEErrorConfiguration(this.asyncAEErrorConfiguration);
            this.asyncAEErrorConfiguration.sParentObject(this);
            if (cls == AsyncAggregateErrorConfiguration.class) {
                this.asyncAEErrorConfiguration.getGetMetadataErrors().setTimeout(0);
            }
        } else if (!isTopAnalysisEngine && !this.isAsync()) {
            int value = this.asyncAEErrorConfiguration.getGetMetadataErrors().getMaxRetries();
            if (value != 0) {
                throw new InvalidXMLException("invalid_element_text", new Object[]{value, "maxRetries"});
            }
            value = this.asyncAEErrorConfiguration.getProcessCasErrors().getMaxRetries();
            if (value != 0) {
                throw new InvalidXMLException("invalid_element_text", new Object[]{value, "maxRetries"});
            }
        }
    }

    @Override
    public void toXML(ContentHandler aContentHandler, boolean aWriteDefaultNamespaceAttribute) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        if (!this.isTopAnalysisEngine() && this.getKey() != null && this.getKey().trim().length() > 0) {
            attrs.addAttribute("", "key", "key", null, this.getKey());
        }
        attrs.addAttribute("", "async", "async", null, Boolean.toString(this.isAsync()));
        if (this.inputQueueScaleout > 0) {
            attrs.addAttribute("", "inputQueueScaleout", "inputQueueScaleout", null, "" + this.inputQueueScaleout);
        }
        if (this.internalReplyQueueScaleout > 0) {
            attrs.addAttribute("", "internalReplyQueueScaleout", "internalReplyQueueScaleout", null, "" + this.internalReplyQueueScaleout);
        }
        aContentHandler.startElement("", "analysisEngine", "analysisEngine", attrs);
        attrs.clear();
        if (this.getNumberOfInstances() != -1) {
            attrs.addAttribute("", "numberOfInstances", "numberOfInstances", null, "" + this.getNumberOfInstances());
            aContentHandler.startElement("", "scaleout", "scaleout", attrs);
            aContentHandler.endElement("", "", "scaleout");
            attrs.clear();
        }
        if (!this.isAsync() && AEDeploymentDescription_Impl.isCASMultiplier(this.getResourceSpecifier()) && this.getCasMultiplierPoolSize() != -1) {
            attrs.addAttribute("", "poolSize", "poolSize", null, "" + this.getCasMultiplierPoolSize());
            attrs.addAttribute("", "initialFsHeapSize", "initialFsHeapSize", null, "" + this.initialFsHeapSize);
            attrs.addAttribute("", "processParentLast", "processParentLast", null, "" + this.getProcessParentCASLast());
            aContentHandler.startElement("", "casMultiplier", "casMultiplier", attrs);
            aContentHandler.endElement("", "", "casMultiplier");
            attrs.clear();
        }
        if (this.isAsync() && this.delegates != null) {
            aContentHandler.startElement("", "delegates", "delegates", attrs);
            for (XMLizable x : this.delegates.getDelegates()) {
                Object aeDepl;
                if (x instanceof AEDeploymentMetaData_Impl) {
                    aeDepl = (AEDeploymentMetaData)x;
                    aeDepl.toXML(aContentHandler, aWriteDefaultNamespaceAttribute);
                    continue;
                }
                if (!(x instanceof RemoteAEDeploymentMetaData_Impl)) continue;
                aeDepl = (RemoteAEDeploymentMetaData_Impl)x;
                ((RemoteAEDeploymentMetaData_Impl)aeDepl).toXML(aContentHandler, aWriteDefaultNamespaceAttribute);
            }
            aContentHandler.endElement("", "", "delegates");
        }
        if (this.asyncAEErrorConfiguration != null) {
            this.asyncAEErrorConfiguration.toXML(aContentHandler, aWriteDefaultNamespaceAttribute);
        } else {
            Trace.err(this.getKey() + ": asyncAEErrorConfiguration == null");
        }
        aContentHandler.endElement("", "", "analysisEngine");
    }

    protected XmlizationInfo getXmlizationInfo() {
        return new XmlizationInfo(null, null);
    }

    @Override
    public int getNumberOfInstances() {
        return this.numberOfInstances;
    }

    @Override
    public void setNumberOfInstances(int numberOfInstances) {
        this.numberOfInstances = numberOfInstances;
    }

    @Override
    public int getCasMultiplierPoolSize() {
        return this.casMultiplierPoolSize;
    }

    @Override
    public void setCasMultiplierPoolSize(int poolSize) {
        this.casMultiplierPoolSize = poolSize;
    }

    @Override
    public AEDelegates_Impl getDelegates() {
        return this.delegates;
    }

    @Override
    public void setDelegates(AEDelegates_Impl delegates) {
        this.delegates = delegates;
    }

    @Override
    public void setAsync(boolean async) {
        this.issetAsync = true;
        this.async = async;
        if (!async) {
            this.inputQueueScaleout = -1;
            this.internalReplyQueueScaleout = -1;
        }
    }

    @Override
    public boolean getProcessParentCASLast() {
        return this.processParentCASLast;
    }

    @Override
    public void setProcessParentCASLast(boolean value) {
        this.processParentCASLast = value;
    }

    @Override
    public boolean isAsync() {
        return this.async;
    }

    @Override
    public AsyncAEErrorConfiguration getAsyncAEErrorConfiguration() {
        return this.asyncAEErrorConfiguration;
    }

    @Override
    public void setAsyncAEErrorConfiguration(AsyncAEErrorConfiguration asyncAEErrorConfiguration) {
        this.asyncAEErrorConfiguration = asyncAEErrorConfiguration;
        asyncAEErrorConfiguration.sParentObject(this);
    }

    @Override
    public boolean isTopAnalysisEngine() {
        return this.topAnalysisEngine;
    }

    @Override
    public void setTopAnalysisEngine(boolean topAnalysisEngine) {
        if (topAnalysisEngine) {
            this.setKey("Top Analysis Engine");
        }
        this.topAnalysisEngine = topAnalysisEngine;
    }

    @Override
    public Map getDelegateDeployments() {
        return null;
    }

    @Override
    public Import getImportedAE() {
        return this.importedAE;
    }

    @Override
    public void setImportedAE(Import importedAE) {
        this.importedAE = importedAE;
    }

    @Override
    public boolean isCasMultiplier() {
        return this.casMultiplier;
    }

    @Override
    public void setCasMultiplier(boolean casMultiplier) {
        this.casMultiplier = casMultiplier;
    }

    @Override
    public int getInitialFsHeapSize() {
        return this.initialFsHeapSize;
    }

    @Override
    public void setInitialFsHeapSize(int initialFsHeapSize) {
        this.initialFsHeapSize = initialFsHeapSize;
    }

    @Override
    public int getInputQueueScaleout() {
        return this.inputQueueScaleout;
    }

    @Override
    public int getInternalReplyQueueScaleout() {
        return this.internalReplyQueueScaleout;
    }

    @Override
    public void setInputQueueScaleout(int numberOfListeners) {
        this.inputQueueScaleout = numberOfListeners;
    }

    @Override
    public void setInternalReplyQueueScaleout(int numberOfListeners) {
        this.internalReplyQueueScaleout = numberOfListeners;
    }
}

