/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.deployment.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.deployment.AEDeploymentConstants;
import org.apache.uima.aae.deployment.AEDeploymentMetaData;
import org.apache.uima.aae.deployment.AEService;
import org.apache.uima.aae.deployment.AsyncPrimitiveErrorConfiguration;
import org.apache.uima.aae.deployment.impl.AEDeploymentMetaData_Impl;
import org.apache.uima.aae.deployment.impl.NameValue;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.tools.debug.util.Trace;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AEService_Impl
extends MetaDataObject_impl
implements AEService,
AEDeploymentConstants {
    protected String endPoint = null;
    protected String brokerURL = null;
    protected int prefetch = 0;
    protected AEDeploymentMetaData analysisEngineDeploymentMetaData;
    protected Import importDescriptor;
    protected boolean importResolved = false;
    protected ResourceSpecifier topAnalysisEngineDescription;
    protected boolean cPlusPlusTopAE = false;
    protected String customValue;
    protected List<NameValue> environmentVariables = new ArrayList<NameValue>();
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("uimaApplication", new PropertyXmlInfo[]{new PropertyXmlInfo("cpeDescriptor", false), new PropertyXmlInfo("defaultCasProcessorSettings", false)});

    protected ResourceSpecifier resolveImport(ResourceManager aResourceManager) throws InvalidXMLException {
        XMLInputSource input;
        if (this.importDescriptor instanceof Import_impl) {
            ((Import_impl)this.importDescriptor).setSourceUrlIfNull(this.getSourceUrl());
        }
        URL url = this.importDescriptor.findAbsoluteUrl(aResourceManager);
        try {
            input = new XMLInputSource(url);
        }
        catch (IOException e) {
            throw new InvalidXMLException("import_failed_could_not_read_from_url", new Object[]{url, this.importDescriptor.getSourceUrlString()}, (Throwable)e);
        }
        ResourceSpecifier spec = UIMAFramework.getXMLParser().parseResourceSpecifier(input);
        return spec;
    }

    public void buildFromXMLElement(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        NodeList childNodes = aElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n;
            int k;
            NodeList nodes;
            Node curNode = childNodes.item(i);
            if (!(curNode instanceof Element)) continue;
            Element elem = (Element)curNode;
            if ("inputQueue".equalsIgnoreCase(elem.getTagName())) {
                this.checkAndSetInputQueueAttributes(elem);
                continue;
            }
            if ("topDescriptor".equalsIgnoreCase(elem.getTagName())) {
                nodes = elem.getChildNodes();
                if (nodes.getLength() <= 0) continue;
                for (k = 0; k < nodes.getLength(); ++k) {
                    n = nodes.item(k);
                    if (!(n instanceof Element)) continue;
                    if (!((Element)n).getTagName().equalsIgnoreCase("import")) {
                        throw new InvalidXMLException("unknown_element", new Object[]{((Element)n).getTagName()});
                    }
                    this.importDescriptor = (Import)aParser.buildObject((Element)n, aOptions);
                }
                continue;
            }
            if ("analysisEngine".equalsIgnoreCase(elem.getTagName())) {
                this.analysisEngineDeploymentMetaData = (AEDeploymentMetaData)aParser.buildObject(elem, aOptions);
                this.analysisEngineDeploymentMetaData.setTopAnalysisEngine(true);
                continue;
            }
            if ("custom".equalsIgnoreCase(elem.getTagName())) {
                NamedNodeMap map = elem.getAttributes();
                if (map == null) continue;
                for (k = 0; k < map.getLength(); ++k) {
                    Node item = map.item(k);
                    String name = item.getNodeName();
                    String val = item.getNodeValue();
                    val = val == null ? "" : val.trim();
                    if (!"name".equalsIgnoreCase(name)) {
                        throw new InvalidXMLException("unknown_element", new Object[]{name});
                    }
                    this.customValue = val;
                }
                continue;
            }
            if ("environmentVariables".equalsIgnoreCase(elem.getTagName())) {
                nodes = elem.getChildNodes();
                if (nodes.getLength() <= 0) continue;
                for (k = 0; k < nodes.getLength(); ++k) {
                    n = nodes.item(k);
                    if (!(n instanceof Element)) continue;
                    Element e = (Element)n;
                    if ("environmentVariable".equalsIgnoreCase(e.getTagName())) {
                        String envName = this.getValueOfNameAttribute(e);
                        if (envName == null) {
                            throw new InvalidXMLException("unknown_element", new Object[]{e.getTagName()});
                        }
                        if (this.environmentVariables == null) {
                            this.environmentVariables = new ArrayList<NameValue>();
                        }
                        this.environmentVariables.add(new NameValue(envName, e.getTextContent()));
                        continue;
                    }
                    throw new InvalidXMLException("unknown_element", new Object[]{e.getTagName()});
                }
                continue;
            }
            throw new InvalidXMLException("unknown_element", new Object[]{elem.getTagName()});
        }
        if (this.analysisEngineDeploymentMetaData == null) {
            this.analysisEngineDeploymentMetaData = new AEDeploymentMetaData_Impl();
            this.analysisEngineDeploymentMetaData.setTopAnalysisEngine(true);
        }
        if (this.analysisEngineDeploymentMetaData.getAsyncAEErrorConfiguration() == null) {
            Object obj = UIMAFramework.getResourceSpecifierFactory().createObject(AsyncPrimitiveErrorConfiguration.class);
            if (obj == null) {
                Trace.err("Cannot create AsyncPrimitiveErrorConfiguration for TOP");
            }
            this.analysisEngineDeploymentMetaData.setAsyncAEErrorConfiguration((AsyncPrimitiveErrorConfiguration)obj);
        }
    }

    protected String getValueOfNameAttribute(Element elem) throws InvalidXMLException {
        int k;
        NamedNodeMap map = elem.getAttributes();
        if (map != null && (k = 0) < map.getLength()) {
            Node item = map.item(k);
            String name = item.getNodeName();
            String val = item.getNodeValue();
            val = val == null ? "" : val.trim();
            if ("name".equalsIgnoreCase(name)) {
                return val;
            }
            throw new InvalidXMLException("unknown_element", new Object[]{name});
        }
        return null;
    }

    protected void checkAndSetInputQueueAttributes(Element aElement) throws InvalidXMLException {
        NamedNodeMap map = aElement.getAttributes();
        if (map != null) {
            for (int i = 0; i < map.getLength(); ++i) {
                Node item = map.item(i);
                String name = item.getNodeName();
                String val = item.getNodeValue();
                val = val == null ? "" : val.trim();
                if ("endpoint".equalsIgnoreCase(name)) {
                    this.setEndPoint(val);
                    continue;
                }
                if ("brokerURL".equalsIgnoreCase(name)) {
                    this.setBrokerURL(val);
                    continue;
                }
                if ("prefetch".equalsIgnoreCase(name)) {
                    if (val.trim().length() <= 0) continue;
                    this.setPrefetch(Integer.parseInt(val));
                    continue;
                }
                throw new InvalidXMLException("unknown_element", new Object[]{name});
            }
        }
        if (this.getEndPoint() == null) {
            throw new InvalidXMLException("element_not_found", new Object[]{"endpoint", "service"});
        }
        if (this.getBrokerURL() == null) {
            throw new InvalidXMLException("element_not_found", new Object[]{"brokerURL", "service"});
        }
    }

    public void toXML(ContentHandler aContentHandler, boolean aWriteDefaultNamespaceAttribute) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        aContentHandler.startElement("", "service", "service", attrs);
        attrs.addAttribute("", "endpoint", "endpoint", null, this.getEndPoint());
        attrs.addAttribute("", "brokerURL", "brokerURL", null, this.getBrokerURL());
        attrs.addAttribute("", "prefetch", "prefetch", null, "" + this.getPrefetch());
        aContentHandler.startElement("", "inputQueue", "inputQueue", attrs);
        aContentHandler.endElement("", "", "inputQueue");
        attrs.clear();
        if (this.isCPlusPlusTopAE() && this.customValue != null) {
            attrs.addAttribute("", "name", "name", null, this.getCustomValue());
            aContentHandler.startElement("", "custom", "custom", attrs);
            aContentHandler.endElement("", "", "custom");
            attrs.clear();
            if (this.environmentVariables != null && this.environmentVariables.size() > 0) {
                aContentHandler.startElement("", "environmentVariables", "environmentVariables", attrs);
                for (NameValue nv : this.environmentVariables) {
                    attrs.addAttribute("", "name", "name", null, nv.getName());
                    aContentHandler.startElement("", "environmentVariable", "environmentVariable", attrs);
                    aContentHandler.characters(nv.getValue().toCharArray(), 0, nv.getValue().length());
                    aContentHandler.endElement("", "", "environmentVariable");
                    attrs.clear();
                }
                aContentHandler.endElement("", "", "environmentVariables");
            }
        }
        aContentHandler.startElement("", "topDescriptor", "topDescriptor", attrs);
        if (this.importDescriptor != null) {
            this.importDescriptor.toXML(aContentHandler, aWriteDefaultNamespaceAttribute);
        }
        aContentHandler.endElement("", "", "topDescriptor");
        attrs.clear();
        if (this.analysisEngineDeploymentMetaData != null) {
            this.analysisEngineDeploymentMetaData.toXML(aContentHandler, aWriteDefaultNamespaceAttribute);
        }
        aContentHandler.endElement("", "", "service");
    }

    protected XmlizationInfo getXmlizationInfo() {
        return new XmlizationInfo(null, null);
    }

    @Override
    public String getBrokerURL() {
        return this.brokerURL;
    }

    @Override
    public void setBrokerURL(String brokerURL) {
        this.brokerURL = brokerURL;
    }

    @Override
    public String getEndPoint() {
        return this.endPoint;
    }

    @Override
    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    @Override
    public AEDeploymentMetaData getAnalysisEngineDeploymentMetaData() throws InvalidXMLException {
        return this.getAnalysisEngineDeploymentMetaData(UIMAFramework.newDefaultResourceManager());
    }

    @Override
    public AEDeploymentMetaData getAnalysisEngineDeploymentMetaData(ResourceManager aResourceManager) throws InvalidXMLException {
        if (this.analysisEngineDeploymentMetaData == null) {
            return null;
        }
        return this.analysisEngineDeploymentMetaData;
    }

    @Override
    public void setAnalysisEngineDeploymentMetaData(AEDeploymentMetaData analysisEngineDeploymentMetaData) {
        this.analysisEngineDeploymentMetaData = analysisEngineDeploymentMetaData;
        analysisEngineDeploymentMetaData.setTopAnalysisEngine(true);
    }

    @Override
    public Import getImportDescriptor() {
        return this.importDescriptor;
    }

    @Override
    public void setImportDescriptor(Import importDescriptor) {
        this.importDescriptor = importDescriptor;
        this.importResolved = false;
        this.topAnalysisEngineDescription = null;
    }

    @Override
    public ResourceSpecifier getTopAnalysisEngineDescription() throws InvalidXMLException {
        return this.getTopAnalysisEngineDescription(UIMAFramework.newDefaultResourceManager());
    }

    @Override
    public ResourceSpecifier getTopAnalysisEngineDescription(ResourceManager aResourceManager) throws InvalidXMLException {
        if (this.topAnalysisEngineDescription == null) {
            // empty if block
        }
        return this.topAnalysisEngineDescription;
    }

    @Override
    public ResourceSpecifier resolveTopAnalysisEngineDescription(boolean recursive) throws InvalidXMLException {
        return this.resolveTopAnalysisEngineDescription(UIMAFramework.newDefaultResourceManager(), recursive);
    }

    @Override
    public ResourceSpecifier resolveTopAnalysisEngineDescription(ResourceManager aResourceManager, boolean recursive) throws InvalidXMLException {
        if (this.importDescriptor == null) {
            return null;
        }
        this.topAnalysisEngineDescription = this.resolveImport(aResourceManager);
        if (this.topAnalysisEngineDescription != null) {
            this.cPlusPlusTopAE = ((ResourceCreationSpecifier)this.topAnalysisEngineDescription).getFrameworkImplementation().equalsIgnoreCase("org.apache.uima.cpp");
        }
        if (this.topAnalysisEngineDescription != null && this.analysisEngineDeploymentMetaData != null) {
            this.analysisEngineDeploymentMetaData.setResourceSpecifier(this.topAnalysisEngineDescription, aResourceManager, recursive);
        }
        this.importResolved = true;
        return this.topAnalysisEngineDescription;
    }

    public void setTopAnalysisEngineDescription(AnalysisEngineDescription topAnalysisEngineDescription) {
        this.topAnalysisEngineDescription = topAnalysisEngineDescription;
    }

    protected void checkImport() {
        Trace.err(" ---> Import is not resolved");
    }

    protected boolean isImportResolved() {
        return this.importResolved;
    }

    protected void setImportResolved(boolean importResolved) {
        this.importResolved = importResolved;
    }

    @Override
    public int getPrefetch() {
        return this.prefetch;
    }

    @Override
    public void setPrefetch(int prefetch) {
        this.prefetch = prefetch;
    }

    @Override
    public List<NameValue> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    public void setEnvironmentVariables(List<NameValue> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public String getCustomValue() {
        return this.customValue;
    }

    @Override
    public void setCustomValue(String customValue) {
        this.customValue = customValue;
    }

    @Override
    public boolean isCPlusPlusTopAE() {
        return this.cPlusPlusTopAE;
    }

    @Override
    public void setCPlusPlusTopAE(boolean plusPlusTopAE) {
        this.cPlusPlusTopAE = plusPlusTopAE;
    }
}

