/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisAtomizingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Value;

public final class Atomizer
extends UnaryExpression {
    private boolean untyped;
    private static final int STRING_KINDS = 8576;
    private static final int UNTYPED_KINDS = 520;
    private static final int UNTYPED_IF_UNTYPED_KINDS = 526;

    public Atomizer(Expression expression, Configuration configuration) {
        super(expression);
        this.untyped = configuration == null ? false : configuration.areAllNodesUntyped();
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.operand = this.operand.simplify(staticContext);
        if (this.operand instanceof Literal) {
            Item item;
            Value value = ((Literal)this.operand).getValue();
            if (value instanceof AtomicValue) {
                return this.operand;
            }
            SequenceIterator sequenceIterator = value.iterate();
            do {
                if ((item = sequenceIterator.next()) != null) continue;
                return this.operand;
            } while (!(item instanceof NodeInfo));
            return this;
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.typeCheck(staticContext, itemType);
        this.resetStaticProperties();
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        if (typeHierarchy.isSubType(this.operand.getItemType(typeHierarchy), BuiltInAtomicType.ANY_ATOMIC)) {
            Expression.setParentExpression(this.operand, this.getParentExpression());
            return this.operand;
        }
        return this;
    }

    public int computeSpecialProperties() {
        int n = super.computeSpecialProperties();
        return n | 0x400000;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        return Atomizer.getAtomizingIterator(sequenceIterator);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.operand.evaluateItem(xPathContext);
        if (item == null) {
            return null;
        }
        if (item instanceof NodeInfo) {
            SequenceIterator sequenceIterator = item.getTypedValue();
            return sequenceIterator.next();
        }
        return item;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Atomizer.getAtomizedItemType(this.operand, this.untyped, typeHierarchy);
    }

    public static final ItemType getAtomizedItemType(Expression expression, boolean bl, TypeHierarchy typeHierarchy) {
        ItemType itemType = expression.getItemType(typeHierarchy);
        if (itemType.isAtomicType()) {
            return itemType;
        }
        if (itemType instanceof NodeTest) {
            if (itemType instanceof EmptySequenceTest) {
                return itemType;
            }
            int n = ((NodeTest)itemType).getNodeKindMask();
            if (bl) {
                if ((n | 0x2180) == 8576) {
                    return BuiltInAtomicType.STRING;
                }
                if ((n | 0x20E) == 526) {
                    return BuiltInAtomicType.UNTYPED_ATOMIC;
                }
            } else if ((n | 0x208) == 520) {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
            return itemType.getAtomizedItemType();
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public int computeCardinality() {
        SchemaType schemaType;
        if (this.untyped) {
            return this.operand.getCardinality();
        }
        if (Cardinality.allowsMany(this.operand.getCardinality())) {
            return 57344;
        }
        Executable executable = this.getExecutable();
        if (executable == null) {
            return 57344;
        }
        ItemType itemType = this.operand.getItemType(executable.getConfiguration().getTypeHierarchy());
        if (itemType.isAtomicType()) {
            return this.operand.getCardinality();
        }
        if (itemType instanceof NodeTest && (schemaType = ((NodeTest)itemType).getContentType()).isAtomicType()) {
            return this.operand.getCardinality();
        }
        return 57344;
    }

    public static SequenceIterator getAtomizingIterator(SequenceIterator sequenceIterator) {
        if (sequenceIterator instanceof AxisIterator) {
            return new AxisAtomizingIterator((AxisIterator)sequenceIterator);
        }
        return new MappingIterator(sequenceIterator, AtomizingFunction.getInstance());
    }

    protected String displayOperator(Configuration configuration) {
        return "atomize";
    }

    public static class AtomizingFunction
    implements MappingFunction {
        private static final AtomizingFunction theInstance = new AtomizingFunction();

        private AtomizingFunction() {
        }

        public static AtomizingFunction getInstance() {
            return theInstance;
        }

        public SequenceIterator map(Item item) throws XPathException {
            if (item instanceof NodeInfo) {
                return item.getTypedValue();
            }
            return SingletonIterator.makeIterator(item);
        }
    }
}

