/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.IntegerRangeTest;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PositionRange;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.RangeExpression;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.SingletonComparison;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Minimax;
import net.sf.saxon.functions.Position;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.GenericAtomicComparer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public class GeneralComparison
extends BinaryExpression
implements ComparisonExpression {
    protected int singletonOperator;
    protected AtomicComparer comparer;

    public GeneralComparison(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
        this.singletonOperator = GeneralComparison.getSingletonOperator(n);
    }

    public AtomicComparer getAtomicComparer() {
        return this.comparer;
    }

    public int getSingletonOperator() {
        return this.singletonOperator;
    }

    public boolean convertsUntypedToOther() {
        return true;
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        Expression expression = this.operand0;
        Expression expression2 = this.operand1;
        this.operand0 = this.operand0.typeCheck(staticContext, itemType);
        this.operand1 = this.operand1.typeCheck(staticContext, itemType);
        if (Literal.isEmptySequence(this.operand0) || Literal.isEmptySequence(this.operand1)) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        Optimizer optimizer = staticContext.getConfiguration().getOptimizer();
        this.operand0 = ExpressionTool.unsorted(optimizer, this.operand0, false);
        this.operand1 = ExpressionTool.unsorted(optimizer, this.operand1, false);
        SequenceType sequenceType = SequenceType.ATOMIC_SEQUENCE;
        RoleLocator roleLocator = new RoleLocator(1, Token.tokens[this.operator], 0, null);
        roleLocator.setSourceLocator(this);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, sequenceType, false, roleLocator, staticContext);
        RoleLocator roleLocator2 = new RoleLocator(1, Token.tokens[this.operator], 1, null);
        roleLocator2.setSourceLocator(this);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, sequenceType, false, roleLocator2, staticContext);
        if (this.operand0 != expression) {
            this.adoptChildExpression(this.operand0);
        }
        if (this.operand1 != expression2) {
            this.adoptChildExpression(this.operand1);
        }
        ItemType itemType2 = this.operand0.getItemType(typeHierarchy);
        ItemType itemType3 = this.operand1.getItemType(typeHierarchy);
        if (itemType2 instanceof EmptySequenceTest || itemType3 instanceof EmptySequenceTest) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        BuiltInAtomicType builtInAtomicType = (BuiltInAtomicType)itemType2.getPrimitiveItemType();
        BuiltInAtomicType builtInAtomicType2 = (BuiltInAtomicType)itemType3.getPrimitiveItemType();
        int n = this.operand0.getCardinality();
        int n2 = this.operand1.getCardinality();
        if (n == 8192 || n2 == 8192) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        if (!(itemType2.equals(BuiltInAtomicType.ANY_ATOMIC) || itemType2.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || itemType3.equals(BuiltInAtomicType.ANY_ATOMIC) || itemType3.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || Type.isComparable(builtInAtomicType, builtInAtomicType2, Token.isOrderedOperator(this.singletonOperator)))) {
            StaticError staticError = new StaticError("Cannot compare " + itemType2.toString(staticContext.getNamePool()) + " to " + itemType3.toString(staticContext.getNamePool()));
            staticError.setErrorCode("XPTY0004");
            staticError.setIsTypeError(true);
            staticError.setLocator(this);
            throw staticError;
        }
        if (n == 16384 && n2 == 16384 && !itemType2.equals(BuiltInAtomicType.ANY_ATOMIC) && !itemType3.equals(BuiltInAtomicType.ANY_ATOMIC)) {
            Expression expression3 = this.operand0;
            Expression expression4 = this.operand1;
            if (itemType2.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                if (itemType3.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    expression3 = new CastExpression(this.operand0, BuiltInAtomicType.STRING, false);
                    this.adoptChildExpression(expression3);
                    expression4 = new CastExpression(this.operand1, BuiltInAtomicType.STRING, false);
                    this.adoptChildExpression(expression4);
                } else if (typeHierarchy.isSubType(itemType3, BuiltInAtomicType.NUMERIC)) {
                    expression3 = new CastExpression(this.operand0, BuiltInAtomicType.DOUBLE, false);
                    this.adoptChildExpression(expression3);
                } else {
                    expression3 = new CastExpression(this.operand0, (AtomicType)itemType3, false);
                    this.adoptChildExpression(expression3);
                }
            } else if (itemType3.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                if (typeHierarchy.isSubType(itemType2, BuiltInAtomicType.NUMERIC)) {
                    expression4 = new CastExpression(this.operand1, BuiltInAtomicType.DOUBLE, false);
                    this.adoptChildExpression(expression4);
                } else {
                    expression4 = new CastExpression(this.operand1, (AtomicType)itemType2, false);
                    this.adoptChildExpression(expression4);
                }
            }
            ValueComparison valueComparison = new ValueComparison(expression3, this.singletonOperator, expression4);
            ExpressionTool.copyLocationInfo(this, valueComparison);
            valueComparison.setParentExpression(this.getParentExpression());
            return valueComparison.simplify(staticContext).typeCheck(staticContext, itemType);
        }
        String string = staticContext.getDefaultCollationName();
        StringCollator stringCollator = staticContext.getCollation(string);
        if (stringCollator == null) {
            stringCollator = CodepointCollator.getInstance();
        }
        this.comparer = GenericAtomicComparer.makeAtomicComparer(builtInAtomicType, builtInAtomicType2, stringCollator, staticContext.getConfiguration());
        if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
            return Literal.makeLiteral((AtomicValue)this.evaluateItem(staticContext.makeEarlyEvaluationContext()));
        }
        return this;
    }

    private static Expression makeMinOrMax(Expression expression, StaticContext staticContext, String string) {
        FunctionCall functionCall = SystemFunction.makeSystemFunction(string, 1, staticContext.getNamePool());
        Expression[] expressionArray = new Expression[]{expression};
        functionCall.setArguments(expressionArray);
        ((Minimax)functionCall).setIgnoreNaN(true);
        return functionCall;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        Object object;
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        this.operand0 = this.operand0.optimize(optimizer, staticContext, itemType);
        this.operand1 = this.operand1.optimize(optimizer, staticContext, itemType);
        Value value = null;
        if (this.operand0 instanceof Literal) {
            value = ((Literal)this.operand0).getValue();
        }
        Value value2 = null;
        if (this.operand1 instanceof Literal) {
            value2 = ((Literal)this.operand1).getValue();
        }
        if (Literal.isEmptySequence(this.operand0) || Literal.isEmptySequence(this.operand1)) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        this.operand0 = ExpressionTool.unsorted(optimizer, this.operand0, false);
        this.operand1 = ExpressionTool.unsorted(optimizer, this.operand1, false);
        ItemType itemType2 = this.operand0.getItemType(typeHierarchy);
        ItemType itemType3 = this.operand1.getItemType(typeHierarchy);
        int n = this.operand0.getCardinality();
        int n2 = this.operand1.getCardinality();
        if (!Cardinality.allowsMany(n) && !Cardinality.allowsMany(n2)) {
            SingletonComparison singletonComparison = new SingletonComparison(this.operand0, this.singletonOperator, this.operand1);
            ExpressionTool.copyLocationInfo(this, singletonComparison);
            singletonComparison.setParentExpression(this.getParentExpression());
            singletonComparison.setComparator(this.comparer);
            return singletonComparison.optimize(optimizer, staticContext, itemType);
        }
        if (!Cardinality.allowsMany(n)) {
            GeneralComparison generalComparison = this.getInverseComparison();
            ExpressionTool.copyLocationInfo(this, generalComparison);
            generalComparison.setParentExpression(this.getParentExpression());
            generalComparison.comparer = this.comparer;
            return generalComparison.optimize(optimizer, staticContext, itemType);
        }
        if (n == 16384 && n2 == 16384 && !itemType2.equals(BuiltInAtomicType.ANY_ATOMIC) && !itemType3.equals(BuiltInAtomicType.ANY_ATOMIC)) {
            Expression expression = this.operand0;
            Expression expression2 = this.operand1;
            if (itemType2.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                if (itemType3.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    expression = new CastExpression(this.operand0, BuiltInAtomicType.STRING, false);
                    this.adoptChildExpression(expression);
                    expression2 = new CastExpression(this.operand1, BuiltInAtomicType.STRING, false);
                    this.adoptChildExpression(expression2);
                } else if (typeHierarchy.isSubType(itemType3, BuiltInAtomicType.NUMERIC)) {
                    expression = new CastExpression(this.operand0, BuiltInAtomicType.DOUBLE, false);
                    this.adoptChildExpression(expression);
                } else {
                    expression = new CastExpression(this.operand0, (AtomicType)itemType3, false);
                    this.adoptChildExpression(expression);
                }
            } else if (itemType3.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                if (typeHierarchy.isSubType(itemType2, BuiltInAtomicType.NUMERIC)) {
                    expression2 = new CastExpression(this.operand1, BuiltInAtomicType.DOUBLE, false);
                    this.adoptChildExpression(expression2);
                } else {
                    expression2 = new CastExpression(this.operand1, (AtomicType)itemType2, false);
                    this.adoptChildExpression(expression2);
                }
            }
            ValueComparison valueComparison = new ValueComparison(expression, this.singletonOperator, expression2);
            ExpressionTool.copyLocationInfo(this, valueComparison);
            valueComparison.setParentExpression(this.getParentExpression());
            return valueComparison.simplify(staticContext).typeCheck(staticContext, itemType).optimize(optimizer, staticContext, itemType);
        }
        String string = staticContext.getDefaultCollationName();
        StringCollator stringCollator = staticContext.getCollation(string);
        if (stringCollator == null) {
            stringCollator = CodepointCollator.getInstance();
        }
        BuiltInAtomicType builtInAtomicType = (BuiltInAtomicType)itemType2.getPrimitiveItemType();
        BuiltInAtomicType builtInAtomicType2 = (BuiltInAtomicType)itemType3.getPrimitiveItemType();
        this.comparer = GenericAtomicComparer.makeAtomicComparer(builtInAtomicType, builtInAtomicType2, stringCollator, staticContext.getConfiguration());
        Expression expression = this.operand0;
        Expression expression3 = this.operand1;
        boolean bl = typeHierarchy.isSubType(itemType2, BuiltInAtomicType.NUMERIC);
        boolean bl2 = typeHierarchy.isSubType(itemType3, BuiltInAtomicType.NUMERIC);
        if (bl2 && !bl) {
            object = new RoleLocator(1, Token.tokens[this.operator], 0, null);
            ((RoleLocator)object).setSourceLocator(this);
            expression = TypeChecker.staticTypeCheck(expression, SequenceType.NUMERIC_SEQUENCE, false, (RoleLocator)object, staticContext);
        }
        if (bl && !bl2) {
            object = new RoleLocator(1, Token.tokens[this.operator], 1, null);
            ((RoleLocator)object).setSourceLocator(this);
            expression3 = TypeChecker.staticTypeCheck(expression3, SequenceType.NUMERIC_SEQUENCE, false, (RoleLocator)object, staticContext);
        }
        if (n2 == 16384) {
            object = new RangeVariableDeclaration();
            ((RangeVariableDeclaration)object).setVariableName("qq:" + object.hashCode());
            SequenceType sequenceType = SequenceType.makeSequenceType(expression.getItemType(typeHierarchy), 16384);
            ((RangeVariableDeclaration)object).setRequiredType(sequenceType);
            VariableReference variableReference = new VariableReference((VariableDeclaration)object);
            SingletonComparison singletonComparison = new SingletonComparison(variableReference, this.singletonOperator, expression3);
            singletonComparison.setComparator(this.comparer);
            QuantifiedExpression quantifiedExpression = new QuantifiedExpression();
            quantifiedExpression.setOperator(31);
            quantifiedExpression.setVariableDeclaration((RangeVariableDeclaration)object);
            quantifiedExpression.setSequence(expression);
            quantifiedExpression.setAction(singletonComparison);
            quantifiedExpression.setLocationId(this.getLocationId());
            quantifiedExpression.setParentExpression(this.getParentExpression());
            return quantifiedExpression.typeCheck(staticContext, itemType).optimize(optimizer, staticContext, itemType);
        }
        if (this.operator != 6 && this.operator != 22 && (typeHierarchy.isSubType(itemType2, BuiltInAtomicType.NUMERIC) || typeHierarchy.isSubType(itemType3, BuiltInAtomicType.NUMERIC))) {
            switch (this.operator) {
                case 12: 
                case 14: {
                    object = new ValueComparison(GeneralComparison.makeMinOrMax(expression, staticContext, "min"), this.singletonOperator, GeneralComparison.makeMinOrMax(expression3, staticContext, "max"));
                    ((ValueComparison)object).setResultWhenEmpty(BooleanValue.FALSE);
                    break;
                }
                case 11: 
                case 13: {
                    object = new ValueComparison(GeneralComparison.makeMinOrMax(expression, staticContext, "max"), this.singletonOperator, GeneralComparison.makeMinOrMax(expression3, staticContext, "min"));
                    ((ValueComparison)object).setResultWhenEmpty(BooleanValue.FALSE);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown operator " + this.operator);
                }
            }
            ExpressionTool.copyLocationInfo(this, (Expression)object);
            ((Expression)object).setParentExpression(this.getParentExpression());
            return ((ValueComparison)object).typeCheck(staticContext, itemType);
        }
        if (this.operand0 instanceof RangeExpression && typeHierarchy.isSubType(this.operand1.getItemType(typeHierarchy), BuiltInAtomicType.INTEGER) && this.operator == 6 && !Cardinality.allowsMany(this.operand1.getCardinality())) {
            object = ((RangeExpression)this.operand0).operand0;
            Expression expression4 = ((RangeExpression)this.operand0).operand1;
            if (this.operand1 instanceof Position) {
                PositionRange positionRange = new PositionRange((Expression)object, expression4);
                ExpressionTool.copyLocationInfo(this, positionRange);
                positionRange.setParentExpression(this.getParentExpression());
                return positionRange;
            }
            IntegerRangeTest integerRangeTest = new IntegerRangeTest(this.operand1, (Expression)object, expression4);
            ExpressionTool.copyLocationInfo(this, integerRangeTest);
            integerRangeTest.setParentExpression(this.getParentExpression());
            return integerRangeTest;
        }
        if (value instanceof IntegerRange && typeHierarchy.isSubType(this.operand1.getItemType(typeHierarchy), BuiltInAtomicType.INTEGER) && this.operator == 6 && !Cardinality.allowsMany(this.operand1.getCardinality())) {
            long l = ((IntegerRange)value).getStart();
            long l2 = ((IntegerRange)value).getEnd();
            if (this.operand1 instanceof Position) {
                PositionRange positionRange = new PositionRange(Literal.makeLiteral(Int64Value.makeIntegerValue(l)), Literal.makeLiteral(Int64Value.makeIntegerValue(l2)));
                ExpressionTool.copyLocationInfo(this, positionRange);
                positionRange.setParentExpression(this.getParentExpression());
                return positionRange;
            }
            IntegerRangeTest integerRangeTest = new IntegerRangeTest(this.operand1, Literal.makeLiteral(Int64Value.makeIntegerValue(l)), Literal.makeLiteral(Int64Value.makeIntegerValue(l2)));
            ExpressionTool.copyLocationInfo(this, integerRangeTest);
            integerRangeTest.setParentExpression(this.getParentExpression());
            return integerRangeTest;
        }
        if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
            return Literal.makeLiteral((AtomicValue)this.evaluateItem(staticContext.makeEarlyEvaluationContext()));
        }
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        try {
            AtomicValue atomicValue;
            SequenceIterator sequenceIterator = this.operand0.iterate(xPathContext);
            SequenceIterator sequenceIterator2 = this.operand1.iterate(xPathContext);
            Value value = (Value)SequenceExtent.makeSequenceExtent(sequenceIterator2);
            int n = value.getLength();
            if (n == 0) {
                return false;
            }
            if (n == 1) {
                AtomicValue atomicValue2;
                AtomicValue atomicValue3 = (AtomicValue)value.itemAt(0);
                while ((atomicValue2 = (AtomicValue)sequenceIterator.next()) != null) {
                    if (!GeneralComparison.compare(atomicValue2, this.singletonOperator, atomicValue3, this.comparer, xPathContext)) continue;
                    return true;
                }
                return false;
            }
            while ((atomicValue = (AtomicValue)sequenceIterator.next()) != null) {
                AtomicValue atomicValue4;
                SequenceIterator sequenceIterator3 = value.iterate();
                while ((atomicValue4 = (AtomicValue)sequenceIterator3.next()) != null) {
                    if (!GeneralComparison.compare(atomicValue, this.singletonOperator, atomicValue4, this.comparer, xPathContext)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (DynamicError dynamicError) {
            if (dynamicError.getXPathContext() == null) {
                dynamicError.setXPathContext(xPathContext);
            }
            if (dynamicError.getLocator() == null) {
                dynamicError.setLocator(this);
            }
            throw dynamicError;
        }
        catch (ValidationException validationException) {
            DynamicError dynamicError = new DynamicError(validationException);
            dynamicError.setXPathContext(xPathContext);
            if (validationException.getLineNumber() == -1) {
                dynamicError.setLocator(this);
            } else {
                dynamicError.setLocator(validationException);
            }
            dynamicError.setErrorCode(validationException.getErrorCodeLocalPart());
            throw dynamicError;
        }
    }

    protected static boolean compare(AtomicValue atomicValue, int n, AtomicValue atomicValue2, AtomicComparer atomicComparer, XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue3 = atomicValue;
        AtomicValue atomicValue4 = atomicValue2;
        if (atomicValue instanceof UntypedAtomicValue) {
            if (atomicValue2 instanceof NumericValue) {
                atomicValue3 = atomicValue.convert(BuiltInAtomicType.DOUBLE, xPathContext);
            } else if (!(atomicValue2 instanceof UntypedAtomicValue)) {
                atomicValue3 = atomicValue.convert(atomicValue2.getPrimitiveType(), xPathContext);
            }
        }
        if (atomicValue2 instanceof UntypedAtomicValue) {
            if (atomicValue instanceof NumericValue) {
                atomicValue4 = atomicValue2.convert(BuiltInAtomicType.DOUBLE, xPathContext);
            } else if (!(atomicValue instanceof UntypedAtomicValue)) {
                atomicValue4 = atomicValue2.convert(atomicValue.getPrimitiveType(), xPathContext);
            }
        }
        return ValueComparison.compare(atomicValue3, n, atomicValue4, atomicComparer);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return BuiltInAtomicType.BOOLEAN;
    }

    private static int getSingletonOperator(int n) {
        switch (n) {
            case 6: {
                return 44;
            }
            case 13: {
                return 48;
            }
            case 22: {
                return 45;
            }
            case 12: {
                return 47;
            }
            case 11: {
                return 46;
            }
            case 14: {
                return 49;
            }
        }
        return n;
    }

    protected GeneralComparison getInverseComparison() {
        return new GeneralComparison(this.operand1, Token.inverse(this.operator), this.operand0);
    }

    protected String displayOperator() {
        return "many-to-many " + super.displayOperator();
    }
}

