/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.wicket.util.convert.converter;

import java.util.Locale;

/**
 * Converts from Object to Integer, adding zero-padding.
 * 
 * @author Eelco Hillenius
 * @author Jonathan Locke
 * @author Al Maw
 * 
 * @deprecated use an {@link IntegerConverter} with suitable format string instead
 */
public class ZeroPaddingIntegerConverter extends IntegerConverter
{
	private static final long serialVersionUID = 1L;

	private final int zeroPadLength;

	/**
	 * Constructs this converter.
	 * 
	 * @param zeroPadLength
	 *            Minimum length of String to be outputted (will be zero-padded).
	 */
	public ZeroPaddingIntegerConverter(final int zeroPadLength)
	{
		this.zeroPadLength = zeroPadLength;
	}

	/**
	 * @see org.apache.wicket.util.convert.converter.AbstractNumberConverter#convertToString(java.lang.Object,
	 *      java.util.Locale)
	 */
	@Override
	public String convertToString(final Integer value, final Locale locale)
	{
		String result = super.convertToString(value, locale);

		while (result.length() < zeroPadLength)
		{
			result = "0" + result;
		}

		return result;
	}
}