
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  Adopt the class attribute node of the fourth acronym element.  Check if this attribute has been adopted successfully by verifying the
 *  nodeName, nodeType, nodeValue, specified and ownerElement attributes of the adopted node.
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-adoptNode">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-adoptNode</a>
*/
public final class documentadoptnode01 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public documentadoptnode01(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Element attrOwnerElem;
      Element element;
      Attr attr;
      NodeList childList;
      Node adoptedclass;
      Node attrsParent;
      String nodeName;
      int nodeType;
      String nodeValue;
      Text firstChild;
      String firstChildValue;
      EntityReference secondChild;
      int secondChildType;
      String secondChildName;
      doc = (Document) load("hc_staff", true);
      childList = doc.getElementsByTagName("acronym");
      element = (Element) childList.item(3);
      attr = element.getAttributeNode("class");
      adoptedclass = doc.adoptNode(attr);
      
      if ((adoptedclass != null)) {
          nodeName = adoptedclass.getNodeName();
      nodeValue = adoptedclass.getNodeValue();
      nodeType = (int) adoptedclass.getNodeType();
      attrOwnerElem = ((Attr) /*Node */adoptedclass).getOwnerElement();
      assertEquals("documentadoptode01_nodeName", "class", nodeName);
      assertEquals("documentadoptNode01_nodeType", 2, nodeType);
      assertNull("documentadoptnode01_ownerDoc", attrOwnerElem);
      firstChild = (Text) adoptedclass.getFirstChild();
      assertNotNull("firstChildNotNull", firstChild);
      firstChildValue = firstChild.getNodeValue();
      
      if (equals("Y", firstChildValue)) {
          secondChild = (EntityReference) firstChild.getNextSibling();
      assertNotNull("secondChildNotNull", secondChild);
      secondChildType = (int) secondChild.getNodeType();
      assertEquals("secondChildIsEntityReference", 5, secondChildType);
      secondChildName = secondChild.getNodeName();
      assertEquals("secondChildIsEnt1Reference", "alpha", secondChildName);
      } else {
          assertEquals("documentadoptnode01_nodeValue", "Yα", nodeValue);
      }
        
    }
    }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/documentadoptnode01";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(documentadoptnode01.class, args);
   }
}

