
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:

 

Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 * Create a document fragment with an entity reference, adopt the node and check
 * that the entity reference value comes from the adopting documents DTD.
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-adoptNode">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-adoptNode</a>
*/
public final class documentadoptnode16 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public documentadoptnode16(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      DocumentFragment docFragment;
      NodeList childList;
      Element parent;
      Element child;
      Attr childsAttr;
      EntityReference entRef;
      Text textNode;
      Node adopted;
      Element parentImp;
      Element childImp;
      NamedNodeMap attributes;
      Attr childAttrImp;
      String nodeValue;
      Node appendedChild;
      Attr attrNode;
      Node firstChild;
      int firstChildType;
      String firstChildName;
      String firstChildValue;
      doc = (Document) load("hc_staff", true);
      docFragment = doc.createDocumentFragment();
      parent = doc.createElement("parent");
      child = doc.createElement("child");
      childsAttr = doc.createAttribute("state");
      entRef = doc.createEntityReference("gamma");
      textNode = doc.createTextNode("Test");
      appendedChild = childsAttr.appendChild(entRef);
      attrNode = child.setAttributeNode(childsAttr);
      appendedChild = child.appendChild(textNode);
      appendedChild = parent.appendChild(child);
      appendedChild = docFragment.appendChild(parent);
      adopted = doc.adoptNode(docFragment);
      
      if ((adopted != null)) {
          parentImp = (Element) adopted.getFirstChild();
      childImp = (Element) parentImp.getFirstChild();
      attributes = childImp.getAttributes();
      childAttrImp = (Attr) attributes.getNamedItem("state");
      firstChild = childAttrImp.getFirstChild();
      assertNotNull("firstChildNotNull", firstChild);
      firstChildName = firstChild.getNodeName();
      firstChildValue = firstChild.getNodeValue();
      firstChildType = (int) firstChild.getNodeType();
      
      if (equals(5, firstChildType)) {
          assertEquals("firstChildEnt3Ref", "gamma", firstChildName);
      } else {
          assertEquals("documentadoptnode16", "Texas", firstChildValue);
      }
        
    }
    }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/documentadoptnode16";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(documentadoptnode16.class, args);
   }
}

